/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public enum Config {
    Global("config.yml", "language"),
    WorldRadio("globalRadio.yml", "worldradios"),
    ServerRadio("globalRadio.yml", "serverradios"),
    PositionRadio("positionRadio.yml", "positionradios"),
    Holograms("holograms.yml", "hologram"),
    Playlists("playlists.yml", "playlist"),
    PlayerVolumes("playerVolumes.yml", "playerVolumes"),
    Songs("songs.yml", "songs");

    private final String defaultYML;
    private final String mainNode;

    public static String createDefaultConfig(Config type) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case Global: {
                sb.append("language: en\n");
                sb.append("config_Playlists: playlists.yml\n");
                sb.append("config_WorldRadio: globalRadio.yml\n");
                sb.append("config_ServerRadio: globalRadio.yml\n");
                sb.append("config_PositionRadio: positionRadio.yml\n");
                sb.append("config_Holograms: holograms.yml\n");
                sb.append("\n");
                sb.append("defaultPlayerVolume: 100\n");
                sb.append("savePlayerVolumes: false\n");
                sb.append("use10OctaveRange: false\n");
                sb.append("\n");
                break;
            }
            case Holograms: {
                sb.append("hologram:\n");
                sb.append("  example_hologram:\n");
                sb.append("    lines:\n");
                sb.append("    - \"Playing: %song_title%\"\n");
                sb.append("    - \"%song_number%/%songs_count%\"\n");
                sb.append("  example_OP_hologram:\n");
                sb.append("    lines:\n");
                sb.append("    - \"Playing: %song_title%\"\n");
                sb.append("    - \"%song_number%/%songs_count%\"\n");
                sb.append("    - \"{next}Skip song\"\n");
                sb.append("\n");
                break;
            }
            case Playlists: {
                sb.append("playlist:\n");
                sb.append("  test_playlist:\n");
                sb.append("  - nyan_cat #must be in plugins/NoteBlockMusicPlayer/songs\n");
                sb.append("  - nyan_cat.nbs\n");
                sb.append("\n");
                break;
            }
            case PositionRadio: {
                sb.append("positionradios:\n");
                sb.append("  test_radio:\n");
                sb.append("    enable: false\n");
                sb.append("    world: world\n");
                sb.append("    x: 0\n");
                sb.append("    y: 100\n");
                sb.append("    z: 0\n");
                sb.append("    radius: 16 #in this radius will player be able to hear music\n");
                sb.append("    hologram: example_hologram\n");
                sb.append("    hologramOP: example_OP_hologram\n");
                sb.append("    repeat: true #repeat playlist?\n");
                sb.append("    random: false #choose random next song from playlist?\n");
                sb.append("    actionbar: true\n");
                sb.append("    delay: 0 #delay between songs in seconds (float)\n");
                sb.append("    playlist: test_playlist\n");
                sb.append("    volume: 100\n");
                sb.append("\n");
                break;
            }
            case ServerRadio: {
                sb.append("serverradios:\n");
                sb.append("  server_radio:\n");
                sb.append("    enable: false #only one server radio can be enabled at same time\n");
                sb.append("    repeat: true #repeat playlist?\n");
                sb.append("    random: false #choose random next song from playlist?\n");
                sb.append("    actionbar: true\n");
                sb.append("    playlist: test_playlist \n");
                sb.append("    delay: 0 #delay between songs in seconds (float)\n");
                sb.append("    volume: 100\n");
                sb.append("\n");
                break;
            }
            case WorldRadio: {
                sb.append("worldradios:\n");
                sb.append("  world_radio:\n");
                sb.append("    enable: false #only one server radio can be enabled at same time\n");
                sb.append("    world: world #only one world radio can be enabled for one world at same time\n");
                sb.append("    repeat: true #repeat playlist?\n");
                sb.append("    random: false #choose random next song from playlist?\n");
                sb.append("    actionbar: true\n");
                sb.append("    playlist: test_playlist \n");
                sb.append("    delay: 0 #delay between songs in seconds (float)\n");
                sb.append("    volume: 100\n");
                sb.append("\n");
                break;
            }
            case PlayerVolumes: {
                sb.append("playerVolumes: []\n");
                break;
            }
            case Songs: {
                sb.append("songs: []");
            }
        }
        return sb.toString();
    }

    private Config(String defaultYML, String mainNode) {
        this.defaultYML = defaultYML;
        this.mainNode = mainNode;
    }

    public String getDefaultYML() {
        return this.defaultYML;
    }

    public static void saveDefaultConfig(Config[] types, String file) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            StringBuilder configStringBuilder = new StringBuilder();
            for (Config type : types) {
                configStringBuilder.append(Config.createDefaultConfig(type));
            }
            config.loadFromString(configStringBuilder.toString());
            config.save(new File(NoteBlockMusicPlayer.getInstance().getDataFolder(), file));
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static YamlConfiguration getConfig(File file, Config type) {
        if (!file.exists()) {
            Config.saveDefaultConfig(new Config[]{type}, file.getName());
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
            if (!config.contains(type.mainNode)) {
                String confString = config.saveToString();
                String sb = confString + "\n\n" + Config.createDefaultConfig(type);
                config.loadFromString(sb);
                config.save(file);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return config;
    }
}

