/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.bukkit.ChatColor;

public enum Language {
    CHAT_PREFIX("prefix", "&9[NoteBlockMusicPlayer] "),
    ACTION_BAR("actionbar", "You are now listening %song_title%"),
    POSITION_RADIO("position_radio", "position"),
    WORLD_RADIO("world_radio", "world"),
    SERVER_RADIO("server_radio", "server"),
    RADIO_NOSONGS("radio_nosongs", "%radio_type% radio '%radio%' is disabled, because it has no songs in playlist.", "Do not use colors for 5 messages below!"),
    RADIO_NOPLAYLIST("radio_noplaylist", "%radio_type% radio '%radio%' is disabled, because playlist '%playlist%' doesn't exist."),
    RADIO_BADWORLD("world_radio_badworld", "%radio_type% radio '%radio%' is disabled, because it's world '%world%' does not exist."),
    WORLD_RADIO_MULTIPLE("world_radio_multiple", "World Radio '%radio%' is disabled, because there is already one world radio enabled in world '%world%'."),
    SERVER_RADIO_MULTIPLE("server_radio_multiple", "Server Radio '%radio%' is disabled, because there is already one server radio enabled."),
    HOLOGRAM_NOT_EXIST("hologram_not_exists", "Hologram '%hologram%' does not exist."),
    COMMAND_HOLOGRAM_RELOAD_SUCCESS("command_hologram_reload_success", "&aHolograms were successfully reloaded from config."),
    COMMAND_HOLOGRAM_RELOAD_FAILED("command_hologram_reload_failed", "&cHolograms weren't successfully reloaded from config."),
    COMMAND_HOLOGRAM_DISABLE("command_hologram_disable", "&cHologram are not enabled on this server."),
    COMMAND_ABOUT("command_about", "&6Use '/noteblockmusicplayer help' for help"),
    COMMAND_PERMISSIONS("command_permission", "&cYou are not allowed to use this command!"),
    COMMAND_SKIP_SONG("command_skip_song", "&aSong '%song_title%' in %radio_type% radio '%radio%' was skipped."),
    COMMAND_SKIP_SONG_NOT_LOADED("command_skip_song_not_loaded", "&c%radio_type%  radio '%radio%' is not properly loaded. Song can't be skipped!"),
    COMMAND_SKIP_HINT("command_skip_hint", "&6Use /%radio_type%radio skip <name of radio>"),
    COMMAND_RADIO_NOTFOUND("command_radio_notfound", "&c%radio_type% radio '%radio%' was not found!"),
    COMMAND_RADIO_RELOAD_SUCCESS("command_radio_reload_success", "&a%radio_type% radios were successfully reloaded from config."),
    COMMAND_RADIO_RELOAD_FAILED("command_radio_reload_failed", "&c%radio_type% radios weren't successfully reloaded from config."),
    COMMAND_STATE_ENABLE("command_state_enable", "&aState of %radio_type% radio '%radio%' was set to enable."),
    COMMAND_STATE_DISABLE("command_state_disable", "&aState of %radio_type% radio '%radio%' was set to disable."),
    COMMAND_STATE_NOT_LOADED("command_state_not_loaded", "&c%radio_type%  radio '%radio%' is not properly loaded. State can't be changed!"),
    COMMAND_STATE_HINT("command_state_hint", "&6Use /%radio_type%radio <enable/disable> <name of radio>"),
    COMMAND_GLOBAL_RELOAD_SUCCESS("command_global_reload_success", "&aConfiguration was successfully reloaded.", "Used when command '/nbmp reload' is executed."),
    COMMAND_GLOBAL_RELOAD_FAILED("command_global_reload_failed", "&cConfiguration wasn't successfully reloaded."),
    COMMAND_RADIO_VOLUME("command_radio_volume", "&aYour volume has been set to %volume%."),
    COMMAND_RADIO_VOLUME_ACTUAL("command_radio_volume_actual", "&aYour volume is %volume%."),
    COMMAND_PLAYLIST_RELOAD_SUCCESS("command_playlist_reload_success", "&aPlaylists were successfully reloaded from config."),
    COMMAND_PLAYLIST_RELOAD_FAILED("command_playlist_reload_failed", "&cPlaylists weren't successfully reloaded from config."),
    COMMAND_PLAYLIST_NOTFOUND("command_playlist_notfound", "&cPlaylist '%playlist%' was not found!"),
    COMMAND_PLAYLIST_SONGS("command_playlist_songs", "&fSongs in playlist %playlist%:"),
    COMMAND_PLAYLIST_SONGS_HINT("command_playlist_songs_hint", "&6Use /nbmp playlist songs <name of playlist>"),
    COMMAND_PLAYLIST_LIST("command_playlist_list", "&fPlaylists on server:"),
    COMMAND_PLAYLIST_CREATE("command_playlist_create", "&aPlaylist with name '%playlist%' was created."),
    COMMAND_PLAYLIST_EXISTS("command_playlist_exists", "&cPlaylist with name '%playlist%' already exists."),
    COMMAND_PLAYLIST_CREATE_HINT("command_playlist_create_hint", "&6Use /nbmp playlist create <name of playlist>"),
    COMMAND_PLAYLIST_ADD("command_playlist_add", "&aSong '%song_title%' was added to playlist '%playlist%'.", "Used when song is added to playlist."),
    COMMAND_PLAYLIST_ADD_HINT("command_playlist_add_hint", "&6Use /nbmp playlist add <name of playlist> <name of song>"),
    COMMAND_PLAYLIST_REMOVE("command_playlist_remove", "&aSong '%song_title%' was removed from playlist '%playlist%'.", "Used when song is removed from playlist."),
    COMMAND_PLAYLIST_REMOVE_HINT("command_playlist_remove_hint", "&6Use /nbmp playlist remove <name of playlist> <name of song>");

    private final String YMLName;
    private final String ENText;
    private final String comment;

    private Language(String YMLName, String ENText) {
        this.YMLName = YMLName;
        this.ENText = ENText;
        this.comment = "";
    }

    private Language(String YMLName, String ENText, String comment) {
        this.YMLName = YMLName;
        this.ENText = ENText;
        this.comment = comment;
    }

    public String getDefaultText() {
        return this.ENText;
    }

    public String getText() {
        String text = NoteBlockMusicPlayer.getInstance().config_language.getString(this.YMLName);
        if (text == null) {
            text = this.ENText;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public String getYMLName() {
        return this.YMLName;
    }

    public String getComment() {
        return this.comment;
    }

    public static void createDefaultYML() {
        ArrayList<String> lines = new ArrayList<String>();
        for (Language lang : Language.values()) {
            if (!lang.getComment().isEmpty()) {
                lines.add("#" + lang.getComment());
            }
            lines.add(lang.getYMLName() + ": " + '\"' + lang.getDefaultText() + '\"');
        }
        Path file = Paths.get(NoteBlockMusicPlayer.getInstance().getDataFolder() + "/messages_en.yml", new String[0]);
        try {
            Files.write(file, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

