/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import java.util.ArrayList;
import java.util.List;

public class MessagePlaceholder {
    public static final String PH_PLAYLIST = "%playlist%";
    public static final String PH_SONG_TITLE = "%song_title%";
    public static final String PH_VOLUME = "%volume%";
    public static final String PH_RADIO = "%radio%";
    public static final String PH_RADIO_TYPE = "%radio_type%";
    public static final String PH_WORLD = "%world%";
    public static final String PH_HOLOGRAM = "%hologram%";
    private final String placeholder;
    private final String text;

    public MessagePlaceholder(String placeholder, String text) {
        this.placeholder = placeholder;
        this.text = text;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getText() {
        return this.text;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<MessagePlaceholder> placeholders = new ArrayList<MessagePlaceholder>();

        public Builder of(String placeholder, String text) {
            this.placeholders.add(new MessagePlaceholder(placeholder, text));
            return this;
        }

        public Builder with(MessagePlaceholder placeholder) {
            this.placeholders.add(placeholder);
            return this;
        }

        public MessagePlaceholder[] get() {
            return this.placeholders.toArray(new MessagePlaceholder[0]);
        }
    }
}

