/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageProcessor {
    private static final MessagePlaceholder[] NO_PLACEHOLDERS = new MessagePlaceholder[0];

    private String getRawMessage(@NotNull Language languageText) {
        String text = languageText.getText();
        return text.isEmpty() ? null : text;
    }

    private String getPrefixedMessage(@Nullable Language prefix, @Nullable String message) {
        if (message == null) {
            return null;
        }
        String prefixText = prefix != null ? prefix.getText() : "";
        return prefixText + message;
    }

    private String getPlaceholderResolvedMessage(@Nullable String message, MessagePlaceholder @NotNull [] placeholders) {
        if (message == null) {
            return null;
        }
        for (MessagePlaceholder placeholder : placeholders) {
            message = message.replace(placeholder.getPlaceholder(), placeholder.getText());
        }
        return message;
    }

    @Nullable
    public final String getMessage(@NotNull Language languageText) {
        return this.getMessage(Language.CHAT_PREFIX, languageText, NO_PLACEHOLDERS, null);
    }

    @Nullable
    public final String getMessage(@NotNull Language languageText, CommandSender commandSender) {
        return this.getMessage(Language.CHAT_PREFIX, languageText, NO_PLACEHOLDERS, commandSender);
    }

    @Nullable
    public final String getMessage(@NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders) {
        return this.getMessage(Language.CHAT_PREFIX, languageText, placeholders, null);
    }

    @Nullable
    public final String getMessage(@NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders, CommandSender commandSender) {
        return this.getMessage(Language.CHAT_PREFIX, languageText, placeholders, commandSender);
    }

    @Nullable
    public final String getMessage(@Nullable Language prefix, @NotNull Language languageText) {
        return this.getMessage(prefix, languageText, NO_PLACEHOLDERS, null);
    }

    @Nullable
    public final String getMessage(@Nullable Language prefix, @NotNull Language languageText, CommandSender commandSender) {
        return this.getMessage(prefix, languageText, NO_PLACEHOLDERS, commandSender);
    }

    @Nullable
    public final String getMessage(@Nullable Language prefix, @NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders) {
        return this.getMessage(prefix, languageText, placeholders, null);
    }

    @Nullable
    public final String getMessage(@Nullable Language prefix, @NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders, @Nullable CommandSender commandSender) {
        String rawMessage = this.getRawMessage(languageText);
        String placeholderResolverMessage = this.getPlaceholderResolvedMessage(rawMessage, placeholders);
        String postProcessedMessage = this.postProcessMessage(commandSender, placeholderResolverMessage);
        return this.getPrefixedMessage(prefix, postProcessedMessage);
    }

    public final String processMessage(@NotNull String message, MessagePlaceholder @NotNull [] placeholders) {
        return this.postProcessMessage(null, this.getPlaceholderResolvedMessage(message, placeholders));
    }

    protected String postProcessMessage(@Nullable CommandSender messageReceiver, @Nullable String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        int textStart = 0;
        while (message.charAt(textStart) == '\u00a7') {
            textStart += 2;
        }
        if (textStart + 1 > message.length()) {
            return message;
        }
        return (textStart > 0 ? message.substring(0, textStart) : "") + message.substring(textStart, textStart + 1).toUpperCase() + message.substring(textStart + 1);
    }

    public final void sendMessage(CommandSender messageReceiver, @NotNull Language languageText) {
        String text = this.getMessage(languageText, messageReceiver);
        if (text != null) {
            messageReceiver.sendMessage(this.postProcessMessage(messageReceiver, text));
        }
    }

    public final void sendMessage(CommandSender messageReceiver, @NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders) {
        String text = this.getMessage(languageText, placeholders, messageReceiver);
        if (text != null) {
            messageReceiver.sendMessage(this.postProcessMessage(messageReceiver, text));
        }
    }

    public final void sendMessage(CommandSender messageReceiver, @NotNull Language languageText, String suffix) {
        String text = this.getMessage(languageText, messageReceiver);
        if (text != null) {
            messageReceiver.sendMessage(this.postProcessMessage(messageReceiver, text) + suffix);
        }
    }

    public final void sendMessage(CommandSender messageReceiver, @NotNull Language languageText, MessagePlaceholder @NotNull [] placeholders, String suffix) {
        String text = this.getMessage(languageText, placeholders, messageReceiver);
        if (text != null) {
            messageReceiver.sendMessage(this.postProcessMessage(messageReceiver, text) + suffix);
        }
    }
}

