/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.objects.SongWithMetadata;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import cz.studiodamage.NoteBlockMusicPlayer.utils.RadioUtils;
import cz.studiodamage.NoteBlockMusicPlayer.utils.SongUtils;
import cz.studiodamage.NoteBlockMusicPlayer.utils.TimeUtils;
import java.util.Map;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoteBlockMusicPlayerPlaceholderExpansion
extends PlaceholderExpansion {
    private static final PlaceholderDefinition[] placeholders = new PlaceholderDefinition[]{new PlaceholderDefinition("song_name", r -> SongUtils.getTitleOrFallback(r.getSongPlayer().getSong())), new PlaceholderDefinition("song_author", r -> ((SongWithMetadata)r.getSongPlayer().getSong()).getCustomArtist()), new PlaceholderDefinition("song_elapsed", r -> TimeUtils.getActualTime("hh:mm:ss", r.getSongPlayer())), new PlaceholderDefinition("song_length", r -> TimeUtils.getLength("hh:mm:ss", r.getSongPlayer()))};

    @NotNull
    public String getIdentifier() {
        return "nbmp";
    }

    @NotNull
    public String getAuthor() {
        return "koca2000";
    }

    @NotNull
    public String getVersion() {
        return Bukkit.getPluginManager().getPlugin("NoteBlockMusicPlayer").getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        String[] sourceParts = params.split("_", 2);
        if (sourceParts.length != 2) {
            return null;
        }
        String source = sourceParts[0];
        PlaceholderDefinition placeholder = this.getPlaceholder(sourceParts[1]);
        if (placeholder == null) {
            return null;
        }
        String placeholderArgument = this.getPlaceholderArgument(placeholder, sourceParts[1]);
        if ("hear".equals(source) && (player == null || !player.isOnline() || placeholderArgument != null)) {
            return null;
        }
        Radio radio = this.getSourceRadio(source, placeholderArgument, player);
        if (radio == null) {
            return "hear".equals(source) ? "" : null;
        }
        return placeholder.getResolver().apply(radio);
    }

    @Nullable
    private String getPlaceholderArgument(@NotNull PlaceholderDefinition placeholderDefinition, @NotNull String params) {
        int length;
        int index = params.indexOf(placeholderDefinition.getPlaceholderName());
        String arguments = params.substring(index + (length = placeholderDefinition.getPlaceholderName().length()));
        if (!arguments.startsWith("_")) {
            return null;
        }
        return arguments.substring(1);
    }

    public Radio getSourceRadio(@NotNull String source, @Nullable String argument, OfflinePlayer offlinePlayer) {
        Map<String, Radio> radios;
        NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
        if ("hear".equals(source)) {
            if (offlinePlayer == null || argument != null) {
                return null;
            }
            Player player = offlinePlayer.getPlayer();
            if (player == null) {
                return null;
            }
            return RadioUtils.getClosestAudibleRadio(player);
        }
        RadioManager radioManager = nbmp.getRadioManager();
        switch (source) {
            case "pos": {
                radios = radioManager.getRadiosOfType(PositionRadio.class);
                break;
            }
            case "world": {
                radios = radioManager.getRadiosOfType(WorldRadio.class);
                break;
            }
            case "server": {
                radios = radioManager.getRadiosOfType(ServerRadio.class);
                break;
            }
            default: {
                return null;
            }
        }
        return radios.get(argument);
    }

    @Nullable
    private PlaceholderDefinition getPlaceholder(String params) {
        for (PlaceholderDefinition placeholderDefinition : placeholders) {
            if (!params.startsWith(placeholderDefinition.getPlaceholderName())) continue;
            return placeholderDefinition;
        }
        return null;
    }

    private static class PlaceholderDefinition {
        private final String placeholderName;
        private final Function<Radio, String> resolver;

        public PlaceholderDefinition(String placeholderName, Function<Radio, String> resolver) {
            this.placeholderName = placeholderName;
            this.resolver = resolver;
        }

        public String getPlaceholderName() {
            return this.placeholderName;
        }

        public Function<Radio, String> getResolver() {
            return this.resolver;
        }
    }
}

