/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import com.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerVolume {
    private static boolean isVolumePersistent = false;
    private static int defaultVolume = 100;
    private static final HashMap<UUID, PlayerVolume> playerVolumes = new HashMap();
    private int volume;
    private boolean mute;

    private PlayerVolume(int volume, boolean mute) {
        this.volume = PlayerVolume.normalizeVolume(volume);
        this.mute = mute;
    }

    public static int changeVolume(Player player, int volume) {
        volume = PlayerVolume.normalizeVolume(volume);
        PlayerVolume pv = playerVolumes.get(player.getUniqueId());
        if (pv == null) {
            pv = new PlayerVolume(volume, false);
        } else {
            pv.volume = volume;
            pv.mute = false;
        }
        playerVolumes.put(player.getUniqueId(), pv);
        NoteBlockAPI.setPlayerVolume((Player)player, (byte)((byte)volume));
        PlayerVolume.save();
        return volume;
    }

    public static int mute(Player player) {
        PlayerVolume pv = playerVolumes.get(player.getUniqueId());
        int volume = 0;
        if (pv == null) {
            pv = new PlayerVolume(defaultVolume, true);
            playerVolumes.put(player.getUniqueId(), pv);
        } else if (pv.mute) {
            pv.mute = false;
            volume = isVolumePersistent ? pv.volume : 100;
        } else {
            pv.mute = true;
        }
        playerVolumes.put(player.getUniqueId(), pv);
        NoteBlockAPI.setPlayerVolume((Player)player, (byte)((byte)volume));
        PlayerVolume.save();
        return volume;
    }

    public static void applyPlayerVolume(Player player) {
        PlayerVolume pv = playerVolumes.get(player.getUniqueId());
        int volume = pv == null ? defaultVolume : (pv.mute ? 0 : pv.volume);
        NoteBlockAPI.setPlayerVolume((Player)player, (byte)((byte)volume));
    }

    public static int getPlayerVolume(Player player) {
        PlayerVolume playerVolume = playerVolumes.get(player.getUniqueId());
        if (playerVolume == null) {
            return defaultVolume;
        }
        return playerVolume.mute ? 0 : playerVolume.volume;
    }

    public static void setVolumePersistent(boolean value) {
        isVolumePersistent = value;
    }

    public static void setDefaultVolume(int volume) {
        defaultVolume = PlayerVolume.normalizeVolume(volume);
    }

    private static int normalizeVolume(int volume) {
        if (volume > 100) {
            volume = 100;
        }
        if (volume < 0) {
            volume = 0;
        }
        return volume;
    }

    public static void save() {
        if (isVolumePersistent) {
            for (Map.Entry<UUID, PlayerVolume> entry : playerVolumes.entrySet()) {
                PlayerVolume pv = entry.getValue();
                YamlConfiguration config = NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PlayerVolumes);
                config.set("playerVolumes." + entry.getKey() + ".volume", (Object)pv.volume);
                config.set("playerVolumes." + entry.getKey() + ".mute", (Object)pv.mute);
            }
            try {
                NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PlayerVolumes).save(new File(NoteBlockMusicPlayer.getInstance().getDataFolder(), Config.PlayerVolumes.getDefaultYML()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void load() {
        if (isVolumePersistent) {
            NoteBlockMusicPlayer.getInstance().configs.put(Config.PlayerVolumes, Config.getConfig(new File(NoteBlockMusicPlayer.getInstance().getDataFolder(), Config.PlayerVolumes.getDefaultYML()), Config.PlayerVolumes));
            ConfigurationSection volumeSection = NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PlayerVolumes).getConfigurationSection("playerVolumes");
            if (volumeSection == null) {
                return;
            }
            for (String key : volumeSection.getKeys(false)) {
                playerVolumes.put(UUID.fromString(key), new PlayerVolume(NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PlayerVolumes).getInt("playerVolumes." + key + ".volume", 100), NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PlayerVolumes).getBoolean("playerVolumes." + key + ".mute", false)));
            }
        }
    }
}

