/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects;

import com.xxmicloxx.NoteBlockAPI.model.Song;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class Playlist {
    private final String name;
    private final com.xxmicloxx.NoteBlockAPI.model.Playlist songs;

    public Playlist(String name, com.xxmicloxx.NoteBlockAPI.model.Playlist songs) {
        this.name = name;
        this.songs = songs;
    }

    public String getName() {
        return this.name;
    }

    public com.xxmicloxx.NoteBlockAPI.model.Playlist getSongs() {
        return this.songs;
    }

    public static HashMap<String, Playlist> load(YamlConfiguration config) {
        HashMap<String, Playlist> map = new HashMap<String, Playlist>();
        ConfigurationSection sec = config.getConfigurationSection("playlist");
        if (sec == null) {
            Bukkit.getLogger().warning("[NoteBlockMusicPlayer] Playlist configuration section not found. No playlist will be loaded.");
            return new HashMap<String, Playlist>();
        }
        for (String key : sec.getKeys(false)) {
            ArrayList<Song> playlist = new ArrayList<Song>();
            List sec2 = config.getStringList("playlist." + key);
            if (sec2.size() > 0) {
                for (String file_name : sec2) {
                    if (file_name.endsWith(".nbs")) {
                        file_name = file_name.replaceAll(".nbs", "");
                    }
                    if (NoteBlockMusicPlayer.getInstance().songs.containsKey(file_name)) {
                        playlist.add(NoteBlockMusicPlayer.getInstance().songs.get(file_name));
                        continue;
                    }
                    NoteBlockMusicPlayer.getInstance().logger.severe("[NoteBlockMusicPlayer] Song " + file_name + " has not been found.");
                }
            }
            com.xxmicloxx.NoteBlockAPI.model.Playlist pl = null;
            if (!playlist.isEmpty()) {
                pl = new com.xxmicloxx.NoteBlockAPI.model.Playlist(playlist.toArray(new Song[0]));
            }
            map.put(key, new Playlist(key, pl));
        }
        return map;
    }

    public static boolean reload() {
        try {
            NoteBlockMusicPlayer.getInstance().checkConfigs();
            NoteBlockMusicPlayer.getInstance().playlists = Playlist.load(NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.Playlists));
            RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
            for (Radio positionRadio : radioManager.getAllRadios()) {
                positionRadio.reloadPlaylist();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void create(String name) {
        YamlConfiguration config = NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.Playlists);
        config.createSection("playlist." + name);
        NoteBlockMusicPlayer.getInstance().savePlaylists();
        Playlist.reload();
    }

    public void add(String SongName) {
        YamlConfiguration config = NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.Playlists);
        List sec = config.getStringList("playlist." + this.name);
        sec.add(SongName);
        config.set("playlist." + this.name, (Object)sec);
        NoteBlockMusicPlayer.getInstance().savePlaylists();
        Playlist.reload();
    }

    public void remove(String SongName) {
        YamlConfiguration config = NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.Playlists);
        List sec = config.getStringList("playlist." + this.name);
        sec.remove(SongName);
        config.set("playlist." + this.name, (Object)sec);
        NoteBlockMusicPlayer.getInstance().savePlaylists();
        Playlist.reload();
    }
}

