/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects.hologram;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.listeners.DecentHologramsListener;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.Hologram;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramConfig;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import eu.decentsoftware.holograms.api.DHAPI;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DecentHologramsHologram
implements Hologram {
    private final String name;
    private final PositionRadio radio;
    private final HologramConfig config;
    private eu.decentsoftware.holograms.api.holograms.Hologram hologram;
    private boolean isTouchable = false;

    public DecentHologramsHologram(String name, PositionRadio radio, HologramConfig config) {
        this.name = name + radio.hashCode();
        this.radio = radio;
        this.config = config;
    }

    @Override
    public void create() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
        this.hologram = DHAPI.createHologram((String)this.name, (Location)new Location(this.radio.getWorld(), this.radio.getX(), this.radio.getY(), this.radio.getZ()));
        this.updateLines();
        this.hologram.setDefaultVisibleState(false);
        DecentHologramsListener.registerHologram(this.hologram, this);
    }

    @Override
    public void updateLines() {
        if (this.hologram == null) {
            this.create();
        }
        this.isTouchable = false;
        ArrayList<String> lines = new ArrayList<String>();
        for (HologramConfig.CustomHologramLine line : this.config.getLines()) {
            lines.add(Hologram.replacePlaceholders(this.radio, line.getTextLine()));
            this.isTouchable |= line.isTouchable();
        }
        DHAPI.setHologramLines((eu.decentsoftware.holograms.api.holograms.Hologram)this.hologram, lines);
    }

    @Override
    public void delete() {
        if (this.hologram != null) {
            DecentHologramsListener.unregisterHologram(this.hologram);
            this.hologram.delete();
            this.hologram = null;
        }
    }

    @Override
    public void setVisible(Player player, boolean visible) {
        if (this.hologram == null) {
            this.create();
        }
        if (visible) {
            this.hologram.setShowPlayer(player);
            this.hologram.showClickableEntities(player);
        } else {
            this.hologram.removeShowPlayer(player);
            this.hologram.hideClickableEntities(player);
        }
    }

    public void onClick(Player player) {
        if (this.isTouchable) {
            Bukkit.getScheduler().runTask((Plugin)NoteBlockMusicPlayer.getInstance(), () -> Hologram.onClick(player, this.radio));
        }
    }
}

