/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects.hologram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class HologramConfig {
    List<CustomHologramLine> lines = new ArrayList<CustomHologramLine>();
    private final String name;

    public HologramConfig(String name, List<String> linesRaw) {
        this.name = name;
        for (String line : linesRaw) {
            boolean touchable = false;
            if (line.contains("{next}")) {
                touchable = true;
                line = line.replace("{next}", "");
            }
            line = line.replaceAll("&0", "" + ChatColor.BLACK).replaceAll("&1", "" + ChatColor.DARK_BLUE).replaceAll("&2", "" + ChatColor.DARK_GREEN).replaceAll("&3", "" + ChatColor.DARK_AQUA).replaceAll("&4", "" + ChatColor.DARK_RED).replaceAll("&5", "" + ChatColor.DARK_PURPLE).replaceAll("&6", "" + ChatColor.GOLD).replaceAll("&7", "" + ChatColor.GRAY).replaceAll("&8", "" + ChatColor.DARK_GRAY).replaceAll("&9", "" + ChatColor.BLUE).replaceAll("&a", "" + ChatColor.GREEN).replaceAll("&b", "" + ChatColor.AQUA).replaceAll("&c", "" + ChatColor.RED).replaceAll("&d", "" + ChatColor.LIGHT_PURPLE).replaceAll("&e", "" + ChatColor.YELLOW).replaceAll("&f", "" + ChatColor.WHITE).replaceAll("&l", "" + ChatColor.BOLD).replaceAll("&m", "" + ChatColor.STRIKETHROUGH).replaceAll("&n", "" + ChatColor.UNDERLINE).replaceAll("&o", "" + ChatColor.ITALIC).replaceAll("&r", "" + ChatColor.RESET);
            this.lines.add(new CustomHologramLine(line, touchable));
        }
    }

    public List<CustomHologramLine> getLines() {
        return this.lines;
    }

    public String getName() {
        return this.name;
    }

    public static HashMap<String, HologramConfig> load(FileConfiguration config) {
        HashMap<String, HologramConfig> holograms = new HashMap<String, HologramConfig>();
        ConfigurationSection sec = config.getConfigurationSection("hologram");
        if (sec == null) {
            Bukkit.getLogger().warning("[NoteBlockMusicPlayer] Holograms configuration not found. Feature will not work properly.");
            return new HashMap<String, HologramConfig>();
        }
        for (String key : sec.getKeys(false)) {
            holograms.put(key, new HologramConfig(key, config.getStringList("hologram." + key + ".lines")));
        }
        return holograms;
    }

    public static class CustomHologramLine {
        private final String textLine;
        private final boolean touchable;

        public CustomHologramLine(String textLine, boolean touchable) {
            this.textLine = textLine;
            this.touchable = touchable;
        }

        public String getTextLine() {
            return this.textLine;
        }

        public boolean isTouchable() {
            return this.touchable;
        }
    }
}

