/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.objects.hologram;

import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.VisibilityManager;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.Hologram;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramConfig;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysHologram
implements Hologram {
    private com.gmail.filoghost.holographicdisplays.api.Hologram hologram;
    private final HologramConfig config;
    private final PositionRadio radio;

    public HolographicDisplaysHologram(PositionRadio radio, HologramConfig config) {
        this.radio = radio;
        this.config = config;
    }

    @Override
    public void create() {
        if (this.hologram != null) {
            this.hologram.delete();
        }
        this.hologram = HologramsAPI.createHologram((Plugin)NoteBlockMusicPlayer.getInstance(), (Location)new Location(this.radio.getWorld(), this.radio.getX(), this.radio.getY(), this.radio.getZ()));
        this.updateLines();
        this.hologram.getVisibilityManager().setVisibleByDefault(false);
    }

    @Override
    public void updateLines() {
        if (this.hologram == null) {
            this.create();
        }
        this.hologram.clearLines();
        for (HologramConfig.CustomHologramLine line : this.config.getLines()) {
            TextLine textline = this.hologram.appendTextLine(Hologram.replacePlaceholders(this.radio, line.getTextLine()));
            if (!line.isTouchable()) continue;
            textline.setTouchHandler(p -> Hologram.onClick(p, this.radio));
        }
    }

    @Override
    public void delete() {
        if (this.hologram != null) {
            this.hologram.delete();
            this.hologram = null;
        }
    }

    @Override
    public void setVisible(Player player, boolean visible) {
        if (this.hologram == null) {
            this.create();
        }
        VisibilityManager visibilityManager = this.hologram.getVisibilityManager();
        if (visible) {
            visibilityManager.showTo(player);
        } else {
            visibilityManager.resetVisibility(player);
        }
    }
}

