/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.player;

import com.xxmicloxx.NoteBlockAPI.model.Playlist;
import com.xxmicloxx.NoteBlockAPI.model.RepeatMode;
import com.xxmicloxx.NoteBlockAPI.model.playmode.ChannelMode;
import com.xxmicloxx.NoteBlockAPI.model.playmode.MonoStereoMode;
import com.xxmicloxx.NoteBlockAPI.model.playmode.StereoMode;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.RadioConfig;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class GlobalRadio
extends Radio {
    protected RadioSongPlayer player;

    public GlobalRadio(RadioConfig radioConfig) {
        super(radioConfig);
    }

    @Override
    public void updatePlayingSong() {
        this.actualSong = this.player.getPlayedSongIndex();
        for (Player p : NoteBlockMusicPlayer.getInstance().getServer().getOnlinePlayers()) {
            List<Radio> inRadios;
            if (!this.isListening(p) || !(inRadios = NoteBlockMusicPlayer.getInstance().getRadioManager().applyPriorities(p)).contains(this)) continue;
            this.showActionBar(p);
        }
        this.player.setPlaying(false);
        Bukkit.getScheduler().runTaskLater((Plugin)NoteBlockMusicPlayer.getInstance(), () -> this.player.setPlaying(true), Math.round(20.0 * this.delay));
    }

    @Override
    protected void createPlayer(Playlist song) {
        this.player = new RadioSongPlayer(song);
        this.player.setVolume((byte)this.volume);
        StereoMode mode = new StereoMode();
        mode.setFallbackChannelMode((ChannelMode)new MonoStereoMode());
        this.player.setChannelMode((ChannelMode)mode);
        if (this.repeat) {
            this.player.setRepeatMode(RepeatMode.ALL);
        }
        this.player.setEnable10Octave(NoteBlockMusicPlayer.getInstance().use10OctaveRange);
        this.player.setRandom(this.random);
        this.player.setPlaying(this.enable);
    }

    @Override
    public void addPlayer(@NotNull Player p) {
        if (this.loaded && this.players.add(p.getUniqueId())) {
            this.checkPermissions();
            this.showActionBar(p);
        }
    }

    @Override
    public void removePlayer(@NotNull Player p) {
        if (this.loaded) {
            this.players.remove(p.getUniqueId());
            this.player.removePlayer(p);
        }
    }

    public static void checkEnable() {
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        boolean server = false;
        for (ServerRadio gRadio : radioManager.getRadiosOfType(ServerRadio.class).values()) {
            if (!gRadio.isLoaded() || !gRadio.isEnable()) continue;
            if (!server) {
                server = true;
                continue;
            }
            gRadio.setEnable(false);
            NoteBlockMusicPlayer.getInstance().logger.severe("[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.SERVER_RADIO_MULTIPLE, MessagePlaceholder.builder().of("%radio%", gRadio.getName()).get()));
        }
        ArrayList<World> w = new ArrayList<World>();
        for (WorldRadio wRadio : radioManager.getRadiosOfType(WorldRadio.class).values()) {
            if (!wRadio.isLoaded() || !wRadio.isEnable()) continue;
            if (!w.contains(wRadio.getWorld())) {
                w.add(wRadio.getWorld());
                continue;
            }
            wRadio.setEnable(false);
            NoteBlockMusicPlayer.getInstance().logger.severe("[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.WORLD_RADIO_MULTIPLE, MessagePlaceholder.builder().of("%radio%", wRadio.getName()).of("%world%", wRadio.getWorld().getName()).get()));
        }
    }

    public void destroy() {
        if (this.loaded) {
            this.player.destroy();
        }
    }

    public RadioSongPlayer getSongPlayer() {
        return this.player;
    }

    @Override
    public void applyPermissions(Set<UUID> uuids) {
        for (UUID u : this.player.getPlayerUUIDs()) {
            if (uuids.contains(u)) continue;
            this.player.removePlayer(u);
        }
        for (UUID u : uuids) {
            if (this.player.getPlayerUUIDs().contains(u)) continue;
            this.player.addPlayer(u);
        }
    }
}

