/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.player;

import com.xxmicloxx.NoteBlockAPI.model.Playlist;
import com.xxmicloxx.NoteBlockAPI.model.RepeatMode;
import com.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.Hologram;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramConfig;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramFactory;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.RadioConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PositionRadio
extends Radio {
    private PositionSongPlayer player;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final int radius;
    private Hologram hologramDefault = null;
    private Hologram hologramOp = null;
    private final String hologramName;
    private final String hologramOpName;

    public PositionRadio(RadioConfig radioConfig) {
        super(radioConfig);
        NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
        this.type = Radio.RadioType.POSITION_RADIO;
        this.world = Bukkit.getServer().getWorld(radioConfig.getWorldName());
        this.x = radioConfig.getX();
        this.y = radioConfig.getY();
        this.z = radioConfig.getZ();
        this.radius = radioConfig.getRadius();
        this.hologramName = radioConfig.getHologramName();
        this.hologramOpName = radioConfig.getHologramOPName();
        this.loaded = this.reloadPlaylist();
        if (this.world == null) {
            MessageProcessor messageProcessor = nbmp.getMessageProcessor();
            nbmp.logger.severe("[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.RADIO_BADWORLD, MessagePlaceholder.builder().of("%radio%", this.name).of("%world%", radioConfig.getWorldName()).with(this.getTypePlaceholder()).get()));
            this.loaded = false;
        }
        if (!this.loaded) {
            return;
        }
        this.actualSong = 0;
        this.createPlayer(this.getPlaylist().getSongs());
        if (nbmp.isHologramLibAvailable()) {
            this.createHolograms();
        }
    }

    public static Map<String, PositionRadio> load(FileConfiguration config) {
        HashMap<String, PositionRadio> list = new HashMap<String, PositionRadio>();
        ConfigurationSection sec = config.getConfigurationSection("positionradios");
        if (sec == null) {
            return list;
        }
        for (String key : sec.getKeys(false)) {
            String hologram = config.getString("positionradios." + key + ".hologram", "none");
            String hologramOP = config.getString("positionradios." + key + ".hologramOP", "none");
            if ("true".equals(hologram) || "false".equals(hologram)) {
                NoteBlockMusicPlayer.getInstance().logger.severe("[NoteBlockMusicPlayer] Please change hologram settings in config to hologram name.");
                hologram = "none";
                hologramOP = "none";
            }
            if (hologram.trim().isEmpty()) {
                hologram = "none";
            }
            if (hologramOP.trim().isEmpty()) {
                hologramOP = "none";
            }
            RadioConfig radioConfig = new RadioConfig().setName(key).setEnable(config.getBoolean("positionradios." + key + ".enable", false)).setWorldName(config.getString("positionradios." + key + ".world")).setX(config.getDouble("positionradios." + key + ".x")).setY(config.getDouble("positionradios." + key + ".y")).setZ(config.getDouble("positionradios." + key + ".z")).setRadius(config.getInt("positionradios." + key + ".radius", 16)).setRepeat(config.getBoolean("positionradios." + key + ".repeat", false)).setRandom(config.getBoolean("positionradios." + key + ".random", false)).setPlaylistName(config.getString("positionradios." + key + ".playlist")).setHologramName(hologram).setHologramOPName(hologramOP).setShowActionBar(config.getBoolean("positionradios." + key + ".actionbar", false)).setVolume(config.getInt("positionradios." + key + ".volume", 100)).setDelay(config.getDouble("positionradios." + key + ".delay", 0.0));
            list.put(key, new PositionRadio(radioConfig));
        }
        return list;
    }

    public Hologram createHologram(String hologramName) {
        if ("none".equalsIgnoreCase(hologramName)) {
            return null;
        }
        NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
        HologramConfig config = nbmp.hologram_list.get(hologramName);
        if (config == null) {
            MessageProcessor messageProcessor = nbmp.getMessageProcessor();
            nbmp.logger.severe("[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.HOLOGRAM_NOT_EXIST, MessagePlaceholder.builder().of("%hologram%", hologramName).get()));
            return null;
        }
        HologramFactory factory = NoteBlockMusicPlayer.getInstance().getHologramFactory();
        if (factory == null) {
            return null;
        }
        Hologram hologram = factory.createHologram(hologramName, this, config);
        hologram.create();
        return hologram;
    }

    public void createHolograms() {
        if (NoteBlockMusicPlayer.getInstance().isHologramLibAvailable()) {
            this.hologramDefault = this.createHologram(this.hologramName);
            this.hologramOp = this.createHologram(this.hologramOpName);
        }
        this.checkHologramVisibility();
    }

    @Override
    public void updatePlayingSong() {
        this.actualSong = this.player.getPlayedSongIndex();
        if (NoteBlockMusicPlayer.getInstance().isHologramLibAvailable()) {
            if (this.hologramDefault != null) {
                this.hologramDefault.updateLines();
            }
            if (this.hologramOp != null) {
                this.hologramOp.updateLines();
            }
            this.checkHologramVisibility();
        }
        for (Player p : NoteBlockMusicPlayer.getInstance().getServer().getOnlinePlayers()) {
            List<Radio> inRadios;
            if (!this.isListening(p) || !(inRadios = NoteBlockMusicPlayer.getInstance().getRadioManager().applyPriorities(p)).contains(this)) continue;
            this.showActionBar(p);
        }
        this.player.setPlaying(false);
        Bukkit.getScheduler().runTaskLater((Plugin)NoteBlockMusicPlayer.getInstance(), () -> this.player.setPlaying(true), Math.round(20.0 * this.delay));
    }

    public void checkHologramVisibility() {
        if (!this.enable) {
            this.destroyHolograms();
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.players.contains(p.getUniqueId())) {
                this.hideBothHolograms(p);
                continue;
            }
            if (this.hologramOp != null && p.hasPermission("positionradio.hologram")) {
                if (this.hologramDefault != null) {
                    this.hologramDefault.setVisible(p, false);
                }
                this.hologramOp.setVisible(p, true);
                continue;
            }
            if (this.hologramDefault == null) continue;
            this.hologramDefault.setVisible(p, true);
        }
    }

    private void hideBothHolograms(Player p) {
        if (this.hologramDefault != null) {
            this.hologramDefault.setVisible(p, false);
        }
        if (this.hologramOp != null) {
            this.hologramOp.setVisible(p, false);
        }
    }

    @Override
    protected void createPlayer(Playlist song) {
        this.player = new PositionSongPlayer(song);
        this.player.setTargetLocation(new Location(this.world, this.x, this.y, this.z));
        this.player.setDistance(this.radius);
        this.player.setVolume((byte)this.volume);
        this.player.setRandom(this.random);
        if (this.repeat) {
            this.player.setRepeatMode(RepeatMode.ALL);
        }
        for (Player p : NoteBlockMusicPlayer.getInstance().getServer().getOnlinePlayers()) {
            this.players.add(p.getUniqueId());
        }
        this.player.setEnable10Octave(NoteBlockMusicPlayer.getInstance().use10OctaveRange);
        this.checkPermissions();
        this.player.setPlaying(this.enable);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void addPlayer(Player p) {
        if (this.loaded) {
            this.players.add(p.getUniqueId());
            this.checkPermissions();
            if (NoteBlockMusicPlayer.getInstance().isHologramLibAvailable()) {
                this.checkHologramVisibility();
            }
        }
    }

    @Override
    public void removePlayer(Player p) {
        if (this.loaded) {
            this.players.remove(p.getUniqueId());
            this.player.removePlayer(p);
        }
    }

    public void destroy() {
        if (this.loaded) {
            this.player.destroy();
            if (NoteBlockMusicPlayer.getInstance().isHologramLibAvailable()) {
                this.destroyHolograms();
            }
        }
    }

    @Override
    public void setEnable(boolean enable) {
        super.setEnable(enable);
        if (NoteBlockMusicPlayer.getInstance().isHologramLibAvailable()) {
            this.checkHologramVisibility();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getRadius() {
        return this.radius;
    }

    public PositionSongPlayer getSongPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public int getActualSongIndex() {
        return this.actualSong;
    }

    public void destroyHolograms() {
        if (this.hologramDefault != null) {
            this.hologramDefault.delete();
        }
        if (this.hologramOp != null) {
            this.hologramOp.delete();
        }
    }

    @Override
    public void applyPermissions(Set<UUID> uuids) {
        for (UUID u : this.player.getPlayerUUIDs()) {
            if (uuids.contains(u)) continue;
            this.player.removePlayer(u);
        }
        for (UUID u : uuids) {
            if (this.player.getPlayerUUIDs().contains(u)) continue;
            this.player.addPlayer(u);
        }
    }

    @Override
    public boolean isActionBarShownOnAdd() {
        return false;
    }

    @Override
    public boolean isHearableFor(@NotNull Player p) {
        return super.isHearableFor(p) && this.isInSameWorld(p);
    }

    @Override
    public boolean isListening(@NotNull Player player) {
        return this.isHearableFor(player) && this.isInRange(player);
    }

    private boolean isInSameWorld(@NotNull Player p) {
        return p.getWorld().equals((Object)this.world);
    }

    private boolean isInRange(@NotNull Player p) {
        return this.getSongPlayer().isInRange(p);
    }
}

