/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.player;

import com.xxmicloxx.NoteBlockAPI.model.Playlist;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.songplayer.SongPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.player.RadioConfig;
import cz.studiodamage.NoteBlockMusicPlayer.utils.ActionBar;
import cz.studiodamage.NoteBlockMusicPlayer.utils.SongUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class Radio {
    protected boolean enable;
    protected String playlist_name;
    protected boolean showActionBar;
    protected boolean loaded = false;
    protected String name;
    protected cz.studiodamage.NoteBlockMusicPlayer.objects.Playlist playlist;
    protected boolean repeat;
    protected boolean random;
    protected RadioType type;
    protected Set<UUID> players = new HashSet<UUID>();
    protected int actualSong = -1;
    protected int volume;
    protected double delay;

    protected Radio(RadioConfig radioConfig) {
        this.name = radioConfig.getName();
        this.enable = radioConfig.isEnable();
        this.playlist_name = radioConfig.getPlaylistName();
        this.volume = radioConfig.getVolume();
        if (this.volume > 100) {
            this.volume = 100;
        }
        if (this.volume < 0) {
            this.volume = 0;
        }
        this.delay = radioConfig.getDelay() >= 0.0 ? radioConfig.getDelay() : 0.0;
        this.repeat = radioConfig.isRepeat();
        this.random = radioConfig.isRandom();
        this.showActionBar = radioConfig.isShowActionBar();
    }

    public boolean reloadPlaylist() {
        NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
        MessageProcessor messageProcessor = nbmp.getMessageProcessor();
        try {
            this.playlist = nbmp.playlists.get(this.playlist_name);
            if (this.getPlaylist().getSongs() == null) {
                nbmp.logger.severe(() -> "[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.RADIO_NOSONGS, MessagePlaceholder.builder().of("%radio%", this.name).of("%playlist%", this.playlist_name).with(this.getTypePlaceholder()).get()));
                return false;
            }
            if (this.getSongPlayer() != null) {
                this.getSongPlayer().setPlaylist(this.playlist.getSongs());
            }
        }
        catch (Exception e) {
            nbmp.logger.severe(() -> "[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.RADIO_NOPLAYLIST, MessagePlaceholder.builder().of("%radio%", this.name).of("%playlist%", this.playlist_name).with(this.getTypePlaceholder()).get()));
            return false;
        }
        return true;
    }

    protected MessagePlaceholder getTypePlaceholder() {
        return Radio.getTypePlaceholder(this);
    }

    @NotNull
    public static MessagePlaceholder getTypePlaceholder(@NotNull Radio radio) {
        return Radio.getTypePlaceholder(radio.type);
    }

    @NotNull
    public static MessagePlaceholder getTypePlaceholder(@NotNull RadioType type) {
        String text = "";
        switch (type) {
            case POSITION_RADIO: {
                text = Language.POSITION_RADIO.getText();
                break;
            }
            case WORLD_RADIO: {
                text = Language.WORLD_RADIO.getText();
                break;
            }
            case SERVER_RADIO: {
                text = Language.SERVER_RADIO.getText();
            }
        }
        return new MessagePlaceholder("%radio_type%", text);
    }

    public abstract void applyPermissions(Set<UUID> var1);

    public void checkPermissions() {
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (UUID u : this.players) {
            String perm;
            Player player = Bukkit.getPlayer((UUID)u);
            if (player == null || !player.hasPermission((perm = this.type.getPermissionNode()) + this.getName())) continue;
            uuids.add(u);
        }
        this.applyPermissions(uuids);
    }

    public abstract void addPlayer(@NotNull Player var1);

    public abstract void removePlayer(@NotNull Player var1);

    public abstract void updatePlayingSong();

    public boolean isHearableFor(@NotNull Player player) {
        return this.isLoaded() && this.isEnable() && this.hasPermission(player);
    }

    public boolean isListening(@NotNull Player player) {
        return this.isHearableFor(player);
    }

    private boolean hasPermission(@NotNull Player p) {
        String perm = this.type.getPermissionNode();
        return p.hasPermission(perm + this.getName());
    }

    protected abstract void createPlayer(Playlist var1);

    public abstract SongPlayer getSongPlayer();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public cz.studiodamage.NoteBlockMusicPlayer.objects.Playlist getPlaylist() {
        return this.playlist;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void showActionBar(Player p) {
        if (!this.showActionBar) {
            return;
        }
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        Song song = this.getSongPlayer().getSong();
        String message = messageProcessor.getMessage(null, Language.ACTION_BAR, MessagePlaceholder.builder().of("%song_title%", SongUtils.getTitleOrFallback(song)).get(), (CommandSender)p);
        ActionBar.sendActionBar(p, message);
    }

    public boolean isActionBarShownOnAdd() {
        return true;
    }

    public void setEnable(boolean enable) {
        if (this.isLoaded()) {
            this.enable = enable;
            this.getSongPlayer().setPlaying(enable);
        }
    }

    public void playNextSong() {
        this.getSongPlayer().playNextSong();
    }

    public static enum RadioType {
        POSITION_RADIO("nbmp.radio.position.", "position"),
        WORLD_RADIO("nbmp.radio.world.", "world"),
        SERVER_RADIO("nbmp.radio.server.", "server");

        private final String permissionNode;
        private final String commandPart;

        private RadioType(String permissionNode, String commandPart) {
            this.permissionNode = permissionNode;
            this.commandPart = commandPart;
        }

        public String getPermissionNode() {
            return this.permissionNode;
        }

        public String getCommandPart() {
            return this.commandPart;
        }
    }
}

