/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.player;

import cz.studiodamage.NoteBlockMusicPlayer.player.GlobalRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.RadioConfig;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ServerRadio
extends GlobalRadio {
    public ServerRadio(RadioConfig radioConfig) {
        super(radioConfig);
        this.type = Radio.RadioType.SERVER_RADIO;
        this.loaded = this.reloadPlaylist();
        if (!this.loaded) {
            return;
        }
        this.actualSong = 0;
        this.createPlayer(this.getPlaylist().getSongs());
    }

    public static Map<String, ServerRadio> load(FileConfiguration config) {
        HashMap<String, ServerRadio> list = new HashMap<String, ServerRadio>();
        ConfigurationSection sec = config.getConfigurationSection("serverradios");
        if (sec == null) {
            return list;
        }
        for (String key : sec.getKeys(false)) {
            RadioConfig radioConfig = new RadioConfig().setName(key).setEnable(config.getBoolean("serverradios." + key + ".enable", false)).setRepeat(config.getBoolean("serverradios." + key + ".repeat", false)).setRandom(config.getBoolean("serverradios." + key + ".random", false)).setPlaylistName(config.getString("serverradios." + key + ".playlist")).setShowActionBar(config.getBoolean("serverradios." + key + ".actionbar", false)).setVolume(config.getInt("serverradios." + key + ".volume", 100)).setDelay(config.getDouble("serverradios." + key + ".delay", 0.0));
            list.put(key, new ServerRadio(radioConfig));
        }
        return list;
    }
}

