/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.player;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.player.GlobalRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.RadioConfig;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class WorldRadio
extends GlobalRadio {
    private final World world;

    public WorldRadio(RadioConfig radioConfig) {
        super(radioConfig);
        this.type = Radio.RadioType.WORLD_RADIO;
        this.world = Bukkit.getServer().getWorld(radioConfig.getWorldName());
        this.loaded = this.reloadPlaylist();
        if (!"".equals(radioConfig.getWorldName()) && this.world == null) {
            NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
            MessageProcessor messageProcessor = nbmp.getMessageProcessor();
            nbmp.logger.severe("[NoteBlockMusicPlayer] " + messageProcessor.getMessage(null, Language.RADIO_BADWORLD, MessagePlaceholder.builder().of("%radio%", this.name).of("%world%", radioConfig.getWorldName()).with(this.getTypePlaceholder()).get()));
            this.loaded = false;
        }
        if (!this.loaded) {
            return;
        }
        this.actualSong = 0;
        this.createPlayer(this.getPlaylist().getSongs());
    }

    public static Map<String, WorldRadio> load(FileConfiguration config) {
        HashMap<String, WorldRadio> list = new HashMap<String, WorldRadio>();
        ConfigurationSection sec = config.getConfigurationSection("worldradios");
        if (sec == null) {
            return list;
        }
        for (String key : sec.getKeys(false)) {
            RadioConfig radioConfig = new RadioConfig().setName(key).setEnable(config.getBoolean("worldradios." + key + ".enable", false)).setWorldName(config.getString("worldradios." + key + ".world")).setRepeat(config.getBoolean("worldradios." + key + ".repeat", false)).setRandom(config.getBoolean("worldradios." + key + ".random", false)).setPlaylistName(config.getString("worldradios." + key + ".playlist")).setShowActionBar(config.getBoolean("worldradios." + key + ".actionbar", false)).setVolume(config.getInt("worldradios." + key + ".volume", 100)).setDelay(config.getDouble("worldradios." + key + ".delay", 0.0));
            list.put(key, new WorldRadio(radioConfig));
        }
        return list;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean isHearableFor(@NotNull Player p) {
        return super.isHearableFor(p) && this.isInSameWorld(p);
    }

    private boolean isInSameWorld(@NotNull Player p) {
        return p.getWorld().equals((Object)this.world);
    }
}

