/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.utils;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadioUtils {
    private static final AudibleRadioGetter[] closestAudibleRadioGetters = new AudibleRadioGetter[]{RadioUtils::getClosestAudiblePositionRadio, RadioUtils::getAudibleWorldRadio, RadioUtils::getAudibleServerRadio};

    private RadioUtils() {
    }

    @Nullable
    public static Radio getClosestAudibleRadio(@NotNull Player player) {
        for (AudibleRadioGetter getter : closestAudibleRadioGetters) {
            Radio radio = getter.get(player);
            if (radio == null) continue;
            return radio;
        }
        return null;
    }

    @Nullable
    public static PositionRadio getClosestAudiblePositionRadio(@NotNull Player player) {
        Collection<PositionRadio> radios = RadioUtils.getAudiblePositionRadios(player);
        PositionRadio closest = null;
        double closestDistance = Double.MAX_VALUE;
        Location playerLocation = player.getEyeLocation();
        for (PositionRadio radio : radios) {
            double zDiff;
            double yDiff;
            double xDiff = playerLocation.getX() - radio.getX();
            double distance = xDiff * xDiff + (yDiff = playerLocation.getY() - radio.getY()) * yDiff + (zDiff = playerLocation.getZ() - radio.getZ()) * zDiff;
            if (!(distance < closestDistance)) continue;
            closest = radio;
            closestDistance = distance;
        }
        return closest;
    }

    @NotNull
    public static Collection<PositionRadio> getAudiblePositionRadios(@NotNull Player player) {
        ArrayList<PositionRadio> result = new ArrayList<PositionRadio>();
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        for (PositionRadio radio : radioManager.getRadiosOfType(PositionRadio.class).values()) {
            if (!RadioUtils.isRadioAudible(radio) || !RadioUtils.isPlayerInRange(player, radio)) continue;
            radio.checkPermissions();
            if (!RadioUtils.isPlayerInRadio(player, radio)) continue;
            result.add(radio);
        }
        return result;
    }

    @Nullable
    public static WorldRadio getAudibleWorldRadio(@NotNull Player player) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        for (WorldRadio radio : radioManager.getRadiosOfType(WorldRadio.class).values()) {
            if (!RadioUtils.isRadioAudible(radio) || !RadioUtils.isPlayerInSameWorld(player, radio.getWorld())) continue;
            radio.checkPermissions();
            if (!RadioUtils.isPlayerInRadio(player, radio)) continue;
            return radio;
        }
        return null;
    }

    @Nullable
    public static ServerRadio getAudibleServerRadio(@NotNull Player player) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        for (ServerRadio radio : radioManager.getRadiosOfType(ServerRadio.class).values()) {
            if (!RadioUtils.isRadioAudible(radio)) continue;
            radio.checkPermissions();
            if (!RadioUtils.isPlayerInRadio(player, radio)) continue;
            return radio;
        }
        return null;
    }

    private static boolean isPlayerInRadio(@NotNull Player player, @NotNull Radio radio) {
        return radio.getSongPlayer().getPlayerUUIDs().contains(player.getUniqueId());
    }

    private static boolean isRadioAudible(@NotNull Radio radio) {
        return radio.isLoaded() && radio.isEnable();
    }

    private static boolean isPlayerInRange(Player player, @NotNull PositionRadio positionRadio) {
        return RadioUtils.isPlayerInSameWorld(player, positionRadio.getWorld()) && positionRadio.getSongPlayer().isInRange(player);
    }

    private static boolean isPlayerInSameWorld(@NotNull Player player, @NotNull World world) {
        return world.equals((Object)player.getWorld());
    }

    private static interface AudibleRadioGetter {
        public Radio get(@NotNull Player var1);
    }
}

