/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Updater {
    public static boolean checkUpdate(String resource, String actualVersion) throws IOException {
        boolean snapshot = false;
        String versionWithoutBuildType = Updater.getVersionStringWithoutBuildType(actualVersion);
        if (!versionWithoutBuildType.equals(actualVersion)) {
            snapshot = true;
        }
        float version = Updater.getVersionNumber(versionWithoutBuildType);
        URLConnection con = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resource).openConnection();
        String newVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
        float newVer = Updater.getVersionNumber(newVersion);
        return snapshot ? newVer >= version : newVer > version;
    }

    public static float getVersionNumber(String version) {
        version = Updater.getVersionStringWithoutBuildType(version);
        String[] versionParts = version.split("\\.");
        StringBuilder versionString = new StringBuilder("0.");
        for (String vpart : versionParts) {
            if (vpart.length() < 2) {
                versionString.append("0");
            }
            versionString.append(vpart);
        }
        return Float.parseFloat(versionString.toString());
    }

    private static String getVersionStringWithoutBuildType(String versionString) {
        int dashIndex = versionString.indexOf(45);
        if (dashIndex != -1) {
            return versionString.substring(0, dashIndex);
        }
        return versionString;
    }
}

