// ב-path: src/main/java/net/xtreamc/booster/config/BoosterConfig.java
package net.xtreamc.booster.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.fabricmc.loader.api.FabricLoader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class BoosterConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("booster_config.json");
    private static BoosterConfig instance;

    // הגדרות
    public boolean chatClearButton = true;
    public boolean chatQuickCommands = true;
    public boolean titleLastServer = true;
    public boolean chatAddCoordinatesButton = true;
    public boolean chatClearTextButton = true;
    public boolean inventorySearch = true;
    public boolean inventoryProgress = true;
    public boolean deathCoordinates = true;
    public boolean deathInventory = true;
    public boolean deathTeleport = true;
    public boolean inventoryDropAll = true;
    public boolean inventoryDropItemMode = true;
    public boolean inventoryDropItems = true;

    public boolean containerStealStore = true;
    public boolean containerSearchBar = true;
    public boolean containerProgressBar = true;
    public boolean containerStealStoreSelcted = true;

    public boolean gameMenuSingleSaveQuitWorld = true;
    public boolean gameMenuSingleSaveQuitGame = true;

    public boolean gameMenuMultiDisconnectQuitWorld = true;
    public boolean gameMenuMultiDisconnectQuitGame = true;

    public boolean resourcePackAddAll = true;
    public boolean resourcePackRemoveAll = true;


    public static BoosterConfig get() {
        if(instance == null) {
            instance = load();
        }
        return instance;
    }

    public static BoosterConfig load() {
        try {
            if(!Files.exists(CONFIG_FILE)) {
                return new BoosterConfig().saveAndReturn();
            }
            return GSON.fromJson(Files.readString(CONFIG_FILE), BoosterConfig.class);
        } catch (Exception e) {
            e.printStackTrace();
            return new BoosterConfig();
        }
    }

    private BoosterConfig saveAndReturn() throws IOException {
        Files.writeString(CONFIG_FILE, GSON.toJson(this));
        return this;
    }

    public void save() {
        try {
            Files.writeString(CONFIG_FILE, GSON.toJson(this));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}