// ב-Mixin חדש ChatScreenMixin.java
package net.xtreamc.booster.mixin.client;

import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.xtreamc.booster.config.BoosterConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(class_408.class)
public abstract class ChatScreenMixin extends class_437 {

    @Unique
    private String chatInput;
    @Unique private String hoveredPlayer;
    @Unique private int hoveredMessageX;
    @Unique private int hoveredMessageY;
    @Shadow
    private class_342 chatField;

    protected ChatScreenMixin(class_2561 title, String chatInput) {
        super(title);
        this.chatInput = chatInput;
    }






    @Inject(method = "init", at = @At("TAIL"))
    private void addClearButton(CallbackInfo ci) {
        if(!BoosterConfig.load().chatClearButton) return;
        int buttonWidth = 100;
        int buttonHeight = 20;



        this.method_37063(class_4185.method_46430(
                        class_2561.method_43470("\uD83D\uDDD1"),
                        button -> clearChatHistory()
                )
                .method_46434(
                        this.field_22789 / 2 - buttonWidth - 2, // מיקום משמאל לתיבת הטקסט
                        this.field_22790 - 40,
                        buttonWidth,
                        buttonHeight
                )
                .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.clear")))
                .method_46431());
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addAddCoordinatesButton(CallbackInfo ci) {
        if (!BoosterConfig.load().chatAddCoordinatesButton) return;
        int buttonWidth = 100;
        int buttonHeight = 20;

        this.method_37063(class_4185.method_46430(
                        class_2561.method_43471("booster.button.addcords"),
                        button -> addCoordinatesToChat()
                )
                .method_46434(
                        this.field_22789 / 2 + 72,
                        this.field_22790 - 40,
                        buttonWidth,
                        buttonHeight
                )
                .method_46431());
    }

    @Unique
    private void addCoordinatesToChat() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) return;

        class_2338 pos = client.field_1724.method_24515();
        String coords = String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        String currentText = this.chatField.method_1882();
        this.chatField.method_1852(currentText + coords);
    }


    @Inject(method = "render", at = @At("TAIL"))
    private void renderHoverButtons(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        class_338 chatHud = client.field_1705.method_1743();

        // חישוב מיקום הודעות לפי גובה חלון הצ'אט
        int lineHeight = client.field_1772.field_2000 + 2;
        int visibleLines = chatHud.method_1813();
        int chatTop = this.field_22790 - 40 - visibleLines * lineHeight;

        // סריקה ידנית של המיקומים
        for(int i = 0; i < visibleLines; i++) {
            int y = chatTop + i * lineHeight;
            if(mouseY >= y && mouseY <= y + lineHeight) {
                parsePlayerNameFromHud(chatHud, i);
                if(this.hoveredPlayer != null) {
                    this.hoveredMessageX = mouseX;
                    this.hoveredMessageY = y;
                    drawPlayerButtons(context, mouseX, mouseY);
                    break;
                }
            }
        }
    }

    @Unique
    private void parsePlayerNameFromHud(class_338 chatHud, int lineIndex) {
        try {
            // גישה ישירה לרשימת ההודעות הגולמית
            List<?> messages = (List<?>) class_338.class.getDeclaredField("messages").get(chatHud);
            int startIndex = Math.max(0, messages.size() - chatHud.method_1813());

            // המרה למבנה ההודעה הבסיסי
            Object messageEntry = messages.get(startIndex + lineIndex);
            class_2561 message = (class_2561) messageEntry.getClass().getMethod("content").invoke(messageEntry);

            String raw = class_124.method_539(message.getString());
            if(raw != null && raw.startsWith("<")) {
                int endIndex = raw.indexOf('>');
                if(endIndex > 0) {
                    this.hoveredPlayer = raw.substring(1, endIndex);
                    return;
                }
            }
        } catch (Exception e) {
            // טיפול בשגיאות ללא תלות במבנה הפנימי
            e.printStackTrace();
        }
        this.hoveredPlayer = null;
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addClearTextButton(CallbackInfo ci) {
        if(!BoosterConfig.load().chatClearTextButton) return;

        int buttonWidth = 20;
        int buttonHeight = 20;

        this.method_37063(class_4185.method_46430(
                        class_2561.method_30163("X"),
                        button -> this.chatField.method_1852("")
                )
                .method_46434(
                        this.field_22789 / 2 + 174, // מימין לתיבת הטקסט
                        this.field_22790 - 40,
                        buttonWidth,
                        buttonHeight
                )
                .method_46431());
    }

    @Unique
    private void drawPlayerButtons(class_332 context, int mouseX, int mouseY) {
        int buttonWidth = 40;
        int buttonHeight = 12;
        int padding = 2;

        // כפתור הודעה פרטית
        drawButton(context,
                "MSG",
                hoveredMessageX + 5,
                hoveredMessageY,
                buttonWidth,
                buttonHeight,
                mouseX, mouseY,
                0xFF55FF55,
                () -> this.chatInput = "/msg " + hoveredPlayer + " ");

        // כפתור TP ל-OP בלבד
        if(class_310.method_1551().field_1724.method_5687(2)) {
            drawButton(context,
                    "TP",
                    hoveredMessageX + 5 + buttonWidth + padding,
                    hoveredMessageY,
                    buttonWidth,
                    buttonHeight,
                    mouseX, mouseY,
                    0xFFFF5555,
                    () -> class_310.method_1551().field_1724.field_3944.method_45730("tp " + hoveredPlayer)
            );
        }
    }

    @Unique
    private void drawButton(class_332 context, String text, int x, int y, int width, int height,
                            int mouseX, int mouseY, int color, Runnable action) {

        boolean hovered = isHovered(mouseX, mouseY, x, y, width, height);

        // רקע שקוע
        context.method_25294(x, y, x + width, y + height, 0xAA000000);
        // מסגרת דינמית
        context.method_49601(x, y, width, height, hovered ? color : 0xFF666666);
        // טקסט מרכזי
        context.method_25300(
                this.field_22793,
                text,
                x + width/2,
                y + (height - 8)/2,
                hovered ? 0xFFFFFF00 : 0xFFDDDDDD
        );

        // טיפול בלחיצה
        if(hovered && class_310.method_1551().field_1729.method_1608()) {
            action.run();
        }
    }

    @Unique
    private boolean isHovered(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    @Unique
    private void clearChatHistory() {
        if (this.field_22787 != null) {
            // נקה את ההיסטוריה המקומית
            this.field_22787.field_1705.method_1743().method_1808(false);

            // אפשרות לנקות גם את ההיסטוריה השמורה בקבצים
            //if (this.client.options != null) {
                //    this.client.options.getChatMessages().clear();
                //    this.client.options.write();
                //}
        }
    }

    public String getChatInput() {
        return chatInput;
    }

    public void setChatInput(String chatInput) {
        this.chatInput = chatInput;
    }
}