package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7919;
import net.xtreamc.booster.client.MultiSelectState;
import net.xtreamc.booster.config.BoosterConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Mixin(class_465.class)
public abstract class ContainerScreenMixin extends class_437 {

    @Final
    @Shadow protected class_1703 handler;
    @Shadow
    protected int x;
    @Shadow
    protected int y;
    @Unique
    private static final int PROGRESS_WIDTH = 100;
    @Unique
    private static final int PROGRESS_HEIGHT = 8;
    @Unique
    private static final int BACKGROUND_COLOR = 0xFF555555; // אפור
    @Unique
    private static final int FOREGROUND_COLOR = 0xFF00FF00; // ירוק

    @Unique
    private class_342 searchField;
    @Unique
    private final List<Integer> matchingSlots = new ArrayList<>();
    @Unique
    private int totalItems = 0;

    @Unique private class_4185 stealSelectedButton;
    @Unique private class_4185 storeSelectedButton;
    @Unique private MultiSelectState stealSelectedState = MultiSelectState.INACTIVE;
    @Unique private MultiSelectState storeSelectedState = MultiSelectState.INACTIVE;
    @Unique private final Set<Integer> selectedContainerSlots = new HashSet<>();
    @Unique private final Set<Integer> selectedInventorySlots = new HashSet<>();

    @Unique
    private static final class_2561 TEXT_ITEMS = class_2561.method_43471("booster.container.items");
    @Unique
    private static final class_2561 TEXT_STEAL = class_2561.method_43471("booster.button.steal");
    @Unique
    private static final class_2561 TEXT_STORE = class_2561.method_43471("booster.button.store");

    protected ContainerScreenMixin(class_2561 title) {
        super(title);
    }



    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField != null && this.searchField.method_25370()) {
            if (keyCode == 69) { // E
                this.searchField.method_25365(false);
                return true;
            }
            return this.searchField.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers); // חשוב!
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addStealAndStoreButtons(CallbackInfo ci) {
        class_465<?> screen = (class_465<?>) (Object) this;
        class_1703 handler = screen.method_17577();
        class_310 client = class_310.method_1551();

        if (handler instanceof class_1707) {
            class_1707 container = (class_1707) handler;
            int rows = container.method_17388();
            int containerSlots = rows * 9;

            // הגדרת מיקומים לפי סוג תיבה
            int buttonX, buttonY, fieldX, fieldY, fieldWidth, fieldHeight;

            if (rows == 6) { // תיבה כפולה
                buttonX = this.field_22789 / 2;
                buttonY = this.field_22790 / 2 - 108;
                fieldX = this.x + -140 ;
                fieldY = this.field_22790 / 2 - 110;
                fieldWidth = 130;


            } else { // תיבה רגילה (3 שורות) או אחרת
                buttonX = this.field_22789 / 2;
                buttonY = this.field_22790 / 2 - 81;
                fieldX = this.x + 1 ;
                fieldY = this.field_22790 / 2 - 110;
                fieldWidth = 169;
            }
            int baseX = this.field_22789 / 2 + 80;
            int baseY = this.field_22790 / 2 - (rows == 6 ? 108 : 81) + 20;


            if(BoosterConfig.load().containerStealStoreSelcted) {
                this.stealSelectedButton = class_4185.method_46430(class_2561.method_43470("↓*"), b -> handleStealSelected())
                        .method_46434(baseX, baseY, 20, 13)
                        .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.steal_selected")))
                        .method_46431();
                this.method_37063(this.stealSelectedButton);

                this.storeSelectedButton = class_4185.method_46430(class_2561.method_43470("↑*"), b -> handleStoreSelected())
                        .method_46434(baseX, baseY + 16, 20, 13)
                        .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.store_selected")))
                        .method_46431();
                this.method_37063(this.storeSelectedButton);
            }




            // תיבת חיפוש
            this.searchField = new class_342(
                    this.field_22793,
                    fieldX,
                    fieldY,
                    fieldWidth,
                    20,
                    class_2561.method_43470("Search...")
            );

            if(BoosterConfig.load().containerStealStore) {
                // כפתור Steal
                this.method_37063(
                        class_4185.method_46430(class_2561.method_43470("↓"), button -> {
                                    for (int slot = 0; slot < containerSlots; slot++) {
                                        clickSlot(client, handler, slot, class_1713.field_7794);
                                    }
                                })
                                .method_46434(buttonX, buttonY, 40, 13)
                                .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.steal")))
                                .method_46431()
                );

                // כפתור Store
                this.method_37063(
                        class_4185.method_46430(class_2561.method_43470("↑"), button -> {
                                    for (int slot = containerSlots; slot < containerSlots + 36; slot++) {
                                        clickSlot(client, handler, slot, class_1713.field_7794);
                                    }
                                })
                                .method_46434(buttonX + 41, buttonY, 40, 13)
                                .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.store")))
                                .method_46431()
                );
            }


            if(BoosterConfig.load().containerSearchBar) {
                this.method_37063(this.searchField);

                this.searchField.method_1863(this::updateSearch);
            }

        }
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        // הדגשה וספירת פריטים רק בתיבות
        if (this.handler instanceof class_1707) {
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            // הדגשת סלוטים
            int highlightColor = 0x7700FF00;
            for (int slotId : matchingSlots) {
                class_1735 slot = this.handler.field_7761.get(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, highlightColor);
            }

            // ספירת פריטים (כמות כוללת)
            this.totalItems = 0;
            for (int i = 0; i < containerSlots; i++) {
                class_1799 stack = this.handler.field_7761.get(i).method_7677();
                this.totalItems += stack.method_7947();
            }

            // הצגת הספירה
            class_2561 countText = class_2561.method_43470("Items: " + this.totalItems);
            context.method_27535(
                    this.field_22793,
                    countText,
                    this.x + -140,
                    this.field_22790 / 2 - 70,
                    0xFFFFFF
            );
        }

        if (this.handler instanceof class_1707) {
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            // חישוב הפרוגרס
            int maxItems = containerSlots * 64; // מקסימום אפשרי (כל סלוט מלא 64)
            float progress = (float) totalItems / maxItems;
            int progressFilled = (int) (PROGRESS_WIDTH * progress);

            // מיקום הפרוגרס בר - פינה שמאלית עליונה
            int progressX = this.x + -140 ;
            int progressY = this.field_22790 / 2 - 80;

            if(BoosterConfig.load().containerProgressBar) {
                // ציור הרקע
                context.method_25294(
                        progressX,
                        progressY,
                        progressX + PROGRESS_WIDTH,
                        progressY + PROGRESS_HEIGHT,
                        BACKGROUND_COLOR
                );

                // ציור ההתקדמות
                if(progressFilled > 0) {
                    context.method_25294(
                            progressX,
                            progressY,
                            progressX + progressFilled,
                            progressY + PROGRESS_HEIGHT,
                            FOREGROUND_COLOR
                    );
                }

                // הוספת טקסט עם אחוזים
                class_2561 progressText = class_2561.method_43470(String.format("%.1f%%", progress * 100));
                context.method_27535(
                        this.field_22793,
                        progressText,
                        progressX + PROGRESS_WIDTH + 5,
                        progressY,
                        0xFFFFFF
                );
            }


        }
    }

    @Unique
    private void handleStealSelected() {
        if (stealSelectedState == MultiSelectState.INACTIVE) {
            // נכנסים למצב בחירה
            stealSelectedState = MultiSelectState.SELECTING;
            stealSelectedButton.method_25355(class_2561.method_43470("✅"));
            stealSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.accept")));
            selectedContainerSlots.clear();
        } else {
            // מבצעים העברה ויוצאים
            class_310 client = class_310.method_1551();
            for (int slotId : selectedContainerSlots) {
                clickSlot(client, this.handler, slotId, class_1713.field_7794);
            }
            stealSelectedState = MultiSelectState.INACTIVE;
            stealSelectedButton.method_25355(class_2561.method_43470("↓*"));
            stealSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.steal_selected")));
            selectedContainerSlots.clear();
        }
    }

    @Unique
    private void handleStoreSelected() {
        if (storeSelectedState == MultiSelectState.INACTIVE) {
            storeSelectedState = MultiSelectState.SELECTING;
            storeSelectedButton.method_25355(class_2561.method_43470("✅"));
            storeSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.accept")));
            selectedInventorySlots.clear();
        } else {
            class_310 client = class_310.method_1551();
            for (int slotId : selectedInventorySlots) {
                clickSlot(client, this.handler, slotId, class_1713.field_7794);
            }
            storeSelectedState = MultiSelectState.INACTIVE;
            storeSelectedButton.method_25355(class_2561.method_43470("↑*"));
            storeSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.store_selected")));
            selectedInventorySlots.clear();
        }
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void renderSelectionHighlights(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!(handler instanceof class_1707)) return;

        // אדום שקוף ל־Steal Selected
        if (stealSelectedState == MultiSelectState.SELECTING) {
            for (int slotId : selectedContainerSlots) {
                class_1735 slot = this.handler.method_7611(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, 0x44FF0000);
            }
        }
        // אדום שקוף ל־Store Selected
        if (storeSelectedState == MultiSelectState.SELECTING) {
            for (int slotId : selectedInventorySlots) {
                class_1735 slot = this.handler.method_7611(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, 0x44FF0000);
            }
        }
    }

    @Unique
    private void updateSearch(String query) {
        if (this.handler instanceof class_1707) {
            String searchQuery = query.toLowerCase();
            this.matchingSlots.clear();
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            for (int i = 0; i < containerSlots; i++) {
                class_1799 stack = this.handler.field_7761.get(i).method_7677();
                if (!stack.method_7960() &&
                        stack.method_7964().getString().toLowerCase().contains(searchQuery)) {
                    this.matchingSlots.add(i);
                }
            }
        }
    }


    @Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        // בדיקה שהמסך הוא תיבה ולא אינוונטור רגיל
        if (!(handler instanceof class_1707)) return;

        class_465<?> screen = (class_465<?>)(Object)this;
        class_1735 focused = ((HandledScreenAccessor) screen).getFocusedSlot();
        if (focused == null || !focused.method_7681()) return;

        int slotId = this.handler.field_7761.indexOf(focused);
        int containerSlots = ((class_1707)handler).method_17388() * 9;

        // טיפול בלחיצות רק במצב בחירה פעיל
        if (stealSelectedState == MultiSelectState.SELECTING && slotId < containerSlots) {
            if (!selectedContainerSlots.remove(slotId)) {
                selectedContainerSlots.add(slotId);
            }
            cir.setReturnValue(true);
        } else if (storeSelectedState == MultiSelectState.SELECTING && slotId >= containerSlots) {
            if (!selectedInventorySlots.remove(slotId)) {
                selectedInventorySlots.add(slotId);
            }
            cir.setReturnValue(true);
        }
    }

    @Unique
    private void clickSlot(class_310 client, class_1703 handler, int slot, class_1713 action) {
        client.field_1761.method_2906(
                handler.field_7763,
                slot,
                0,
                action,
                client.field_1724
        );
    }
}