package net.xtreamc.booster.mixin.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2813;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_479;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_479.class)
public abstract class CraftingScreenMixin extends class_465<class_1714> {



    @Unique private class_1799[] recipePattern;
    @Unique private boolean isCrafting;

    public CraftingScreenMixin(class_1714 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addCraftAllButton(CallbackInfo ci) {
        this.method_37063(
                class_4185.method_46430(
                                class_2561.method_43470("Craft All"),
                                button -> startAutoCraft()
                        )
                        .method_46434(
                                this.field_2776 + 130,
                                this.field_2800 + 5,
                                80,
                                20
                        )
                        .method_46431()
        );
    }

    @Unique
    private void startAutoCraft() {
        if (isCrafting) return;
        this.recipePattern = captureRecipePattern();
        this.isCrafting = true;
        scheduleNextCraft();
    }

    @Unique
    private class_1799[] captureRecipePattern() {
        class_1799[] pattern = new class_1799[9];
        for (int i = 0; i < 9; i++) {
            // גישה ישירה ל-handler מה-parent class
            pattern[i] = ((class_1714)this.field_2797).method_7611(i + 1).method_7677().method_7972();
        }
        return pattern;
    }

    @Unique
    private void scheduleNextCraft() {
        class_310 client = class_310.method_1551();
        client.method_18858(() -> {
            if (!isCrafting) return;

            if (tryCraft()) {
                scheduleNextCraft();
            } else {
                isCrafting = false;
            }
        });
    }

    @Unique
    private boolean tryCraft() {
        // 1. Check if output exists
        if (!field_2797.method_7611(0).method_7681()) return false;

        // 2. Perform quick craft
        craftOnce();

        // 3. Refill grid from inventory
        boolean refilled = false;
        for (int gridSlot = 0; gridSlot < 9; gridSlot++) {
            if (field_2797.method_7611(gridSlot + 1).method_7677().method_7960()) {
                refilled |= refillSlot(gridSlot + 1);
            }
        }

        return refilled;
    }

    private void craftOnce() {
        class_310 client = class_310.method_1551();
        client.method_1562().method_2883(
                new class_2813(
                        ((class_1714)this.field_2797).field_7763, // המרה מפורשת
                        ((class_1714)this.field_2797).method_37421(),
                        0,
                        0,
                        class_1713.field_7794,
                        class_1799.field_8037,
                        Int2ObjectMaps.emptyMap()
                )
        );
    }

    @Unique
    private boolean refillSlot(int targetSlot) {
        class_1799 required = recipePattern[targetSlot - 1];
        if (required.method_7960()) return false;

        for (int invSlot = 10; invSlot < 36; invSlot++) { // Skip hotbar
            class_1735 slot = field_2797.method_7611(invSlot);
            if (class_1799.method_7984(slot.method_7677(), required)) {
                swapItems(invSlot, targetSlot);
                return true;
            }
        }
        return false;
    }

    @Unique
    private void swapItems(int fromSlot, int toSlot) {
        class_310 client = class_310.method_1551();

        // Pickup item
        client.method_1562().method_2883(
                new class_2813(
                        field_2797.field_7763,
                        field_2797.method_37421(),
                        fromSlot,
                        0,
                        class_1713.field_7790,
                        class_1799.field_8037,
                        Int2ObjectMaps.emptyMap()
                )
        );

        // Place item
        client.method_1562().method_2883(
                new class_2813(
                        field_2797.field_7763,
                        field_2797.method_37421(),
                        toSlot,
                        0,
                        class_1713.field_7790,
                        class_1799.field_8037,
                        Int2ObjectMaps.emptyMap()
                )
        );
    }
}