package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.xtreamc.booster.client.MultiDropState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashSet;
import java.util.Set;

@Mixin(class_481.class)
public abstract class CreativeInventoryScreenMixin extends class_465<class_481.class_483> {

    @Unique
    private MultiDropState deleteItemsState = MultiDropState.INACTIVE;
    @Unique
    private class_4185 deleteItemsButton;

    @Unique
    private int backgroundX;
    @Unique
    private int backgroundY;
    @Unique
    private final Set<Integer> selectedSlotsToDelete = new HashSet<>();

    public CreativeInventoryScreenMixin() {
        super(null, class_310.method_1551().field_1724.method_31548(), class_2561.method_30163(""));
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addDeleteButton(CallbackInfo ci) {
        if (class_310.method_1551().field_1724.method_7337()) {
            this.deleteItemsButton = class_4185.method_46430(
                            class_2561.method_43471("booster.button.delete_items"),
                            button -> handleDeleteItems()
                    )
                    .method_46434(this.field_2776 + 125, this.field_2800 + 83, 46, 13)
                    .method_46431();
            this.method_37063(this.deleteItemsButton);
        }
    }

    @Unique
    private void handleDeleteItems() {
        switch (deleteItemsState) {
            case INACTIVE:
                deleteItemsState = MultiDropState.SELECTING;
                deleteItemsButton.method_25355(class_2561.method_43471("booster.button.click_items"));
                break;
            case SELECTING:
                deleteItemsState = MultiDropState.CONFIRMING;
                deleteItemsButton.method_25355(class_2561.method_43471("booster.button.accept"));
                break;
            case CONFIRMING:
                deleteSelectedItems();
                resetDeleteItemsMode();
                break;
        }
    }

    @Unique
    private void deleteSelectedItems() {
        if (field_22787 == null || field_22787.field_1724 == null || field_22787.field_1761 == null) return;

        for (int slotId : selectedSlotsToDelete) {
            class_1735 slot = this.field_2797.field_7761.get(slotId);
            if (slot.field_7871 == field_22787.field_1724.method_31548()) {
                // שימוש ב-QUICK_MOVE למחיקה מיידית
                field_22787.field_1761.method_2906(
                        field_2797.field_7763,
                        slotId,
                        1, // כפתור ימני (למחיקה מלאה)
                        class_1713.field_7794, // פעולת מחיקה ישירה
                        field_22787.field_1724
                );
            }
        }
    }

    @Unique
    private void resetDeleteItemsMode() {
        deleteItemsState = MultiDropState.INACTIVE;
        selectedSlotsToDelete.clear();
        deleteItemsButton.method_25355(class_2561.method_43471("booster.button.delete_items"));
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void renderDeleteOverlay(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (deleteItemsState != MultiDropState.INACTIVE) {
            for (int slotId : selectedSlotsToDelete) {
                class_1735 slot = this.field_2797.field_7761.get(slotId);
                context.method_25294(
                        this.backgroundX + slot.field_7873,
                        this.backgroundY + slot.field_7872,
                        this.backgroundX + slot.field_7873 + 16,
                        this.backgroundY + slot.field_7872 + 16,
                        0x44FF0000
                );
            }
        }
    }

    @Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (deleteItemsState == MultiDropState.SELECTING) {
            if (this.field_2787 != null && this.field_2787.method_7681()) {
                int slotId = this.field_2787.field_7874;
                if (slotId >= 0 && slotId < 45
                        && this.field_2787.field_7871 == this.field_22787.field_1724.method_31548())
                {
                    if (selectedSlotsToDelete.contains(slotId)) {
                        selectedSlotsToDelete.remove(slotId);
                    } else {
                        selectedSlotsToDelete.add(slotId);
                    }
                    cir.setReturnValue(true); // מבטל את המשך העיבוד
                    cir.cancel();
                }
            }
        }
    }
}