package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_418;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.xtreamc.booster.config.BoosterConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_418.class)
public abstract class DeathScreenMixin extends class_437 {
    @Unique
    private class_2338 deathPos;
    @Unique
    private class_4185 copyButton;
    @Unique
    private class_4185 inventoryButton;
    @Unique
    private boolean showInventory = false;


    @Unique private class_4185 restoreButton;
    @Unique private class_1799[] deathArmor = new class_1799[4];
    @Unique private class_1799 deathOffhand = class_1799.field_8037;

    @Unique
    private class_4185 tpButton;
    @Unique
    private class_1799[] deathInventory = new class_1799[36];


    protected DeathScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addButtons(CallbackInfo ci) {
        BoosterConfig config = BoosterConfig.load();
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.deathPos = this.field_22787.field_1724.method_24515();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                // שמירת האינבנטורי בזמן המוות
                class_1661 inv = field_22787.field_1724.method_31548();
                for (int i = 0; i < 36; i++) {
                    this.deathInventory[i] = inv.method_5438(i).method_7972();
                }
            }



            boolean isOp = this.field_22787.field_1724.method_5687(2);
            // כפתור צפייה באינבנטורי
            this.inventoryButton = class_4185.method_46430(
                            class_2561.method_43471("booster.button.viewinventory"),
                            button -> this.showInventory = !this.showInventory
                    )
                    .method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 145, 200, 20)
                    .method_46431();

            // כפתור העתקת קורדינטות
            this.copyButton = class_4185.method_46430(
                            class_2561.method_43471("booster.button.copycoords"),
                            button -> copyCoords()
                    )
                    .method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 120, 200, 20)
                    .method_46431();

            if(isOp) {
                this.tpButton = class_4185.method_46430(
                                class_2561.method_43471("booster.button.teleport"),
                                button -> handleTeleport()
                        )
                        .method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 170, 200, 20)
                        .method_46431();
                if(config.deathTeleport) {
                    this.method_37063(tpButton);
                }

            }

            if(config.deathCoordinates) {
                this.method_37063(copyButton);
            }



            this.method_37063(inventoryButton);


            class_1661 inv = field_22787.field_1724.method_31548();
            for (int i = 0; i < 36; i++) {
                this.deathInventory[i] = inv.method_5438(i).method_7972();
            }
            for (int i = 0; i < 4; i++) {
                this.deathArmor[i] = inv.method_7372(i).method_7972();
            }
            this.deathOffhand = inv.method_5438(40).method_7972(); // Offhand הוא סלוט 40

            // הוספת כפתור שחזור אינבנטורי
            boolean keepInventory = field_22787.field_1687.method_8450().method_8355(class_1928.field_19389);
            if(isOp && !keepInventory) {
                this.restoreButton = class_4185.method_46430(
                                class_2561.method_43471("booster.button.restoreinventory"),
                                button -> restoreInventory()
                        )
                        .method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 170, 200, 20)
                        .method_46431();
                //this.addDrawableChild(restoreButton);
            }
        }
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void renderCustomElements(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        // הצגת קורדינטות
        if (this.deathPos != null) {
            class_2561 coordsText = class_2561.method_43469("booster.deathcoords.title",
                    deathPos.method_10263(),
                    deathPos.method_10264(),
                    deathPos.method_10260()
            );

            int textWidth = this.field_22793.method_27525(coordsText);
            context.method_27535(
                    this.field_22793,
                    coordsText,
                    (this.field_22789 - textWidth) / 2,
                    this.field_22790 / 4 + 50,
                    0xFFFFFF
            );
        }

        // הצגת האינבנטורי אם הכפתור לחוץ
        if(showInventory && field_22787 != null && field_22787.field_1724 != null) {
            renderPlayerInventory(context);
        }
    }

    @Unique
    private void restoreInventory() {
        if (field_22787 == null || field_22787.field_1724 == null) return;

        class_746 player = field_22787.field_1724;

        // 1. ריספון ישיר ללא צורך בחבילת רשת
        player.method_7331();
        field_22787.method_1507(null);

        // 2. שחזור האינבנטורי לאחר 20 טיקים (1 שנייה)
        field_22787.execute(() -> {
            if(player.method_5805()) {
                class_1661 inv = player.method_31548();

                // שחזור כל הסלוטים
                for(int i = 0; i < 36; i++) {
                    inv.method_5447(i, deathInventory[i].method_7972());
                }
                for(int i = 0; i < 4; i++) {
                    inv.field_7548.set(i, deathArmor[i].method_7972());
                }
                inv.field_7544.set(0, deathOffhand.method_7972());

                // עדכון מצב השחקן בצד הלקוח
                player.method_31549().field_7479 = false;
                player.method_7355();
            }
        });
    }

    private void copyCoords() {
        if (this.deathPos != null) {
            String coords = String.format("%d, %d, %d",
                    deathPos.method_10263(),
                    deathPos.method_10264(),
                    deathPos.method_10260()
            );
            this.field_22787.field_1774.method_1455(coords);
        }
    }

    private void renderPlayerInventory(class_332 context) {
        int startX = 10; // פינה שמאלית
        int startY = 10;

        // רישום הסלוטים מהמאגר השמור
        for(int i = 0; i < 3; ++i) {
            for(int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9 + 9;
                class_1799 stack = deathInventory[slotIndex]; // שימוש במאגר השמור
                int x = startX + j * 18;
                int y = startY + i * 18;
                renderItemSlot(context, stack, x, y);
            }
        }

        // רישום ה-hotbar מהמאגר השמור
        for(int j = 0; j < 9; ++j) {
            class_1799 stack = deathInventory[j];
            int x = startX + j * 18;
            int y = startY + 58;
            renderItemSlot(context, stack, x, y);
        }
    }

    private void renderItemSlot(class_332 context, class_1799 stack, int x, int y) {
        // רישום רקע לסלוט
        context.method_25294(x, y, x + 16, y + 16, 0x44FFFFFF);

        // רישום האייטם
        if(!stack.method_7960()) {
            String count = String.valueOf(stack.method_7947());
            //context.drawTextWithShadow(
            //        this.textRenderer,
            //        count,
            //        x + 12,
            //        y + 9,
            //        0xFFFFFF
            //);
            context.method_51427(stack, x, y);
            context.method_51431(this.field_22793, stack, x, y);
        }
    }

    @Unique
    private void handleTeleport() {
        if (field_22787 == null || deathPos == null || field_22787.field_1724 == null) return;

        // 1. ריספון מיידי
        field_22787.field_1724.method_7331();

        // 2. סגירת מסך המוות
        field_22787.method_1507(null);

        // 3. השגחה על טלפורטציה לאחר 40 טיקים (2 שניות)
        field_22787.execute(() -> {
            class_746 player = field_22787.field_1724;
            if (player != null && player.method_5805()) {
                // בצע טלפורטציה שקטה ללא פקודות
                player.method_5814(deathPos.method_10263() + 0.5, deathPos.method_10264(), deathPos.method_10260() + 0.5);
                player.method_18800(0, 0, 0); // עצור תנועה
            }
        });
    }
}