package net.xtreamc.booster.mixin.client;

import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_526;
import net.xtreamc.booster.config.BoosterConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_433.class)
public abstract class GameMenuScreenMixin extends class_437 {
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 4;

    protected GameMenuScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "initWidgets", at = @At("TAIL"))
    private void addCustomButtons(CallbackInfo ci) {
        int y = calculateStartY();
        boolean isSingleplayer = this.field_22787.method_1542();

        if (isSingleplayer) {
            addSingleplayerButtons(y);
        } else {
            addMultiplayerButtons(y);
        }
    }

    private int calculateStartY() {
        // מצא את הכפתור התחתון ביותר + הוסף מרווח
        return this.field_22790 - 63;
    }

    private void addSingleplayerButtons(int startY) {
        int y = startY;

        if(BoosterConfig.load().gameMenuSingleSaveQuitWorld) {
            // Save & Quit to World Selection
            this.method_37063(createMenuButton(
                    y,
                    "booster.button.single.worldSelect",
                    () -> {
                        assert field_22787 != null;
                        field_22787.field_1687.method_8525();
                        field_22787.method_18099();

                        // שנה את ה-parent screen ל-TitleScreen
                        field_22787.method_1507(new class_526(new class_442()));
                    }
            ));

            y += BUTTON_HEIGHT + BUTTON_SPACING;
        }


        if(BoosterConfig.load().gameMenuSingleSaveQuitWorld) {
            // Save & Quit Game
            this.method_37063(createMenuButton(
                    y,
                    "booster.button.single.quitGame",
                    () -> System.exit(0)
            ));
        }


    }

    private void addMultiplayerButtons(int startY) {
        int y = startY;

        if(BoosterConfig.load().gameMenuMultiDisconnectQuitWorld) {
            // Disconnect & Quit to World Select
            this.method_37063(createMenuButton(
                    y,
                    "booster.button.multi.quitToWorld",
                    () -> {
                        assert field_22787 != null;
                        field_22787.field_1687.method_8525();
                        field_22787.method_18099();

                        // שנה את ה-parent screen ל-TitleScreen
                        field_22787.method_1507(new class_526(new class_442()));
                    }
            ));
            y += BUTTON_HEIGHT + BUTTON_SPACING;
        }

        if(BoosterConfig.load().gameMenuMultiDisconnectQuitWorld) {
            // Disconnect & Quit Game
            this.method_37063(createMenuButton(
                    y,
                    "booster.button.multi.quitGame",
                    () -> System.exit(0)
            ));
        }




    }

    private class_4185 createMenuButton(int y, String translationKey, Runnable action) {
        return class_4185.method_46430(class_2561.method_43471(translationKey), button -> action.run())
                .method_46434(this.field_22789 / 2 - 102, y, 204, BUTTON_HEIGHT)
                .method_46431();
    }
}