package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.xtreamc.booster.client.ModKeyBinds;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
public abstract class InGameHudMixin {
    @Shadow @Final private class_310 client;
    @Shadow private int scaledWidth;
    @Shadow private int scaledHeight;

    @Inject(method = "render", at = @At("TAIL"))
    private void renderOverlay(class_332 context, float tickDelta, CallbackInfo ci) {
        if (ModKeyBinds.SHOW_SLOTS_KEY.method_1434()) {
            renderInventoryOverlay(context);
        }
    }

    @Unique
    private void renderInventoryOverlay(class_332 context) {
        class_1661 inventory = client.field_1724.method_31548();
        int startX = (scaledWidth / 2) - 91;
        int startY = scaledHeight - 100; // מיקום גבוה יותר

        // טקסטורת רקע לסלוטים
        class_2960 SLOT_TEXTURE = new class_2960("textures/gui/container/inventory.png");

        // רנדר 3 שורות בלבד (27 סלוטים)
        for (int row = 0; row < 3; row++) {
            for (int col = 0; col < 9; col++) {
                int slot = col + row * 9 + 9;
                int x = startX + col * 18;
                int y = startY + row * 18;

                // רנדר רקע הסלוט
                context.method_25302(SLOT_TEXTURE, x, y, 7, 83, 18, 18);
                // רנדר האייטם
                renderSlot(context, x + 1, y + 1, inventory.method_5438(slot));
            }
        }
    }

    @Unique
    private int getSlotFromRowColumn(int row, int col) {
        return row < 3 ? (row * 9 + col + 9) : col;
    }

    @Unique
    private void renderSlot(class_332 context, int x, int y, class_1799 stack) {
        context.method_51427(stack, x, y);
        context.method_51431(client.field_1772, stack, x, y);
    }
}