package net.xtreamc.booster.mixin.client;

import net.minecraft.class_2561;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_4185;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_5375;
import net.xtreamc.booster.config.BoosterConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Mixin(class_5375.class)
public abstract class ResourcePackScreenMixin extends class_437 {

    protected ResourcePackScreenMixin(class_2561 title) {
        super(title);
    }



    @Inject(method = "init", at = @At("TAIL"))
    private void addBulkButtons(CallbackInfo ci) {
        int buttonWidth = 100;
        int buttonHeight = 20;
        int padding = 5;

        if(BoosterConfig.load().resourcePackRemoveAll) {
            // כפתור הסר הכל
            this.method_37063(class_4185.method_46430(
                            class_2561.method_43471("booster.button.remove_all"),
                            button -> removeAllPacks()
                    )
                    .method_46434(
                            this.field_22789 - buttonWidth - padding,
                            10,
                            buttonWidth,
                            buttonHeight
                    )
                    .method_46431());
        }

        if(BoosterConfig.load().resourcePackAddAll) {
            // כפתור הוסף הכל
            this.method_37063(class_4185.method_46430(
                            class_2561.method_43471("booster.button.add_all"),
                            button -> addAllPacks()
                    )
                    .method_46434(
                            this.field_22789 - buttonWidth - padding,
                            10 + buttonHeight + padding,
                            buttonWidth,
                            buttonHeight
                    )
                    .method_46431());
        }


    }

    @Unique
    private void removeAllPacks() {
        if (this.field_22787 != null) {
            class_3283 manager = this.field_22787.method_1520();
            manager.method_14447(Collections.emptyList());
            saveAndRefresh(manager);
        }
    }

    @Unique
    private void addAllPacks() {
        if (this.field_22787 != null) {
            class_3283 manager = this.field_22787.method_1520();
            List<String> profiles = manager.method_14441()
                    .stream()
                    .map(class_3288::method_14463)
                    .collect(Collectors.toList());

            manager.method_14447(profiles);
            saveAndRefresh(manager);
        }
    }

    @Unique
    private void saveAndRefresh(class_3283 manager) {
        // 1. שמירת השינויים בהגדרות
        this.field_22787.field_1690.field_1887 = manager.method_14444()
                .stream()
                .map(class_3288::method_14463)
                .collect(Collectors.toList());
        this.field_22787.field_1690.method_1640();

        // 2. טעינה מחדש של המשאבים
        this.field_22787.method_1521().thenRun(() -> {
            if (this.field_22787 != null) {
                // 3. סגירת כל המסכים ופתיחת OptionsScreen חדש
                this.field_22787.method_1507(
                        new class_429(
                                null, // מסך אב - ניתן להחליף למסך ראשי אם צריך
                                this.field_22787.field_1690
                        )
                );
            }
        });
    }
}