// ב-path: src/main/java/net/xtreamc/booster/screen/ConfigScreen.java
package net.xtreamc.booster.screen;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.xtreamc.booster.config.BoosterConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ConfigScreen extends class_437 {
    private final class_437 parent;
    private BoosterConfig config;
    private ScrollableWidget scrollable;
    private final List<ConfigEntry> entries = new ArrayList<>();

    public ConfigScreen(class_437 parent) {
        super(class_2561.method_30163("Booster Config"));
        this.parent = parent;
        this.config = BoosterConfig.load();

        if (this.config == null) {
            this.config = new BoosterConfig();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        entries.clear();
        // Add entries as before
        entries.add(new CategoryHeader("Chat Features"));
        entries.add(new CheckboxEntry("Clear Chat Button", config.chatClearButton, v -> config.chatClearButton = v));
        entries.add(new CheckboxEntry("Quick Commands", config.chatQuickCommands, v -> config.chatQuickCommands = v));
        entries.add(new CheckboxEntry("Add Coordinates Button", config.chatAddCoordinatesButton, v -> config.chatAddCoordinatesButton = v));
        entries.add(new CheckboxEntry("Clear Text Button", config.chatClearTextButton, v -> config.chatClearTextButton = v));

        entries.add(new CategoryHeader("Death Features"));
        entries.add(new CheckboxEntry("Show Coordinates", config.deathCoordinates, v -> config.deathCoordinates = v));
        entries.add(new CheckboxEntry("View Inventory", config.deathInventory, v -> config.deathInventory = v));
        entries.add(new CheckboxEntry("Teleport Button", config.deathTeleport, v -> config.deathTeleport = v));

        entries.add(new CategoryHeader("Inventory Features"));
        entries.add(new CheckboxEntry("Item Search", config.inventorySearch, v -> config.inventorySearch = v));
        entries.add(new CheckboxEntry("Progress Bar", config.inventoryProgress, v -> config.inventoryProgress = v));
        entries.add(new CheckboxEntry("Drop All Button", config.inventoryDropAll, v -> config.inventoryDropAll = v));
        entries.add(new CheckboxEntry("Drop Item Mode", config.inventoryDropItemMode, v -> config.inventoryDropItemMode = v));
        entries.add(new CheckboxEntry("Drop Items Button", config.inventoryDropItems, v -> config.inventoryDropItems = v));

        entries.add(new CategoryHeader("Container Features"));
        entries.add(new CheckboxEntry("Steal/Store Buttons", config.containerStealStore, v -> config.containerStealStore = v));
        entries.add(new CheckboxEntry("Search Bar", config.containerSearchBar, v -> config.containerSearchBar = v));
        entries.add(new CheckboxEntry("Progress Bar", config.containerProgressBar, v -> config.containerProgressBar = v));
        entries.add(new CheckboxEntry("Steal Selected/Store Selected Buttons", config.containerStealStoreSelcted, v -> config.containerStealStoreSelcted = v));

        entries.add(new CategoryHeader("Game Menu (Single Player)"));
        entries.add(new CheckboxEntry("Save & Quit to World", config.gameMenuSingleSaveQuitWorld, v -> config.gameMenuSingleSaveQuitWorld = v));
        entries.add(new CheckboxEntry("Save & Quit Game", config.gameMenuSingleSaveQuitGame, v -> config.gameMenuSingleSaveQuitGame = v));

        entries.add(new CategoryHeader("Game Menu (Multiplayer)"));
        entries.add(new CheckboxEntry("Disconnect & Quit to World", config.gameMenuMultiDisconnectQuitWorld, v -> config.gameMenuMultiDisconnectQuitWorld = v));
        entries.add(new CheckboxEntry("Disconnect & Quit Game", config.gameMenuMultiDisconnectQuitGame, v -> config.gameMenuMultiDisconnectQuitGame = v));

        entries.add(new CategoryHeader("Resource Packs"));
        entries.add(new CheckboxEntry("Add All Button", config.resourcePackAddAll, v -> config.resourcePackAddAll = v));
        entries.add(new CheckboxEntry("Remove All Button", config.resourcePackRemoveAll, v -> config.resourcePackRemoveAll = v));

        scrollable = new ScrollableWidget(
                this.field_22789 / 2 - 160,
                30,
                320,
                this.field_22790 - 60,
                calculateTotalContentHeight()
        );

        this.method_37063(class_4185.method_46430(class_2561.method_30163("Save"), b -> {
            config.save();
            class_310.method_1551().method_1507(parent);
        }).method_46434(field_22789 / 2 - 100, field_22790 - 30, 200, 20).method_46431());
    }

    private int calculateTotalContentHeight() {
        int total = 0;
        for (ConfigEntry entry : entries) {
            total += entry.getHeight() + 4;
        }
        return total + 20;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        method_25420(context);
        scrollable.render(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(field_22793, field_22785, field_22789 / 2, 10, 0xFFFFFF);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (scrollable.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return scrollable.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) ||
                super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        return scrollable.mouseScrolled(mouseX, mouseY, horizontal, vertical);
    }

    private abstract class ConfigEntry {
        abstract void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta);

        abstract int getHeight();
    }

    private class CategoryHeader extends ConfigEntry {
        private final class_2561 text;

        CategoryHeader(String text) {
            this.text = class_2561.method_30163(text);
        }

        @Override
        void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            context.method_27535(field_22793, text, x + 5, y + 5, 0x00FF00);
        }

        @Override
        int getHeight() {
            return 20;
        }
    }

    private class CheckboxEntry extends ConfigEntry {
        private final class_2561 text;
        private boolean value;
        private final class_4185 button;
        private final Consumer<Boolean> setter;

        CheckboxEntry(String text, boolean initial, Consumer<Boolean> setter) {
            this.text = class_2561.method_30163(text);
            this.value = initial;
            this.setter = setter;
            this.button = class_4185.method_46430(getText(), b -> toggle()).method_46431();
        }

        private void toggle() {
            this.value = !this.value;
            setter.accept(this.value);
            button.method_25355(getText());
        }

        public void onClick() {
            toggle();
        }

        private class_2561 getText() {
            return class_2561.method_43470(text.getString() + ": " + (value ? "ON" : "OFF"));
        }

        @Override
        void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            button.method_46421(x + 10);
            button.method_46419(y);
            button.method_25358(200);
            button.method_25355(getText());
            button.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        int getHeight() {
            return 20;
        }
    }

    private class ScrollableWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final int contentHeight;
        private double scrollAmount;

        ScrollableWidget(int x, int y, int width, int height, int contentHeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.contentHeight = contentHeight;
        }

        void render(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_44379(x, y, x + width, y + height);

            int currentY = y - (int) scrollAmount;
            for (ConfigEntry entry : entries) {
                entry.render(context, x, currentY, mouseX, mouseY, delta);
                currentY += entry.getHeight();
            }

            context.method_44380();
            renderScrollbar(context);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!isMouseOver(mouseX, mouseY)) {
                return false;
            }

            double contentY = mouseY - this.y + scrollAmount;
            int accumulatedY = 0;
            for (ConfigEntry entry : entries) {
                int entryHeight = entry.getHeight();
                if (contentY >= accumulatedY && contentY < accumulatedY + entryHeight) {
                    if (entry instanceof CheckboxEntry) {
                        CheckboxEntry checkbox = (CheckboxEntry) entry;
                        // חישוב המיקום המסך של הכפתור
                        int buttonScreenX = x + 10;
                        int buttonScreenY = this.y - (int)scrollAmount + accumulatedY;
                        int buttonWidth = 200;
                        int buttonHeight = 20;

                        // בדיקה אם הלחיצה בתוך הכפתור
                        if (mouseX >= buttonScreenX && mouseX <= buttonScreenX + buttonWidth &&
                                mouseY >= buttonScreenY && mouseY <= buttonScreenY + buttonHeight) {
                            checkbox.onClick();
                            return true;
                        }
                    }
                }
                accumulatedY += entryHeight;
            }
            return false;
        }


        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= x && mouseX <= x + width &&
                    mouseY >= y && mouseY <= y + height;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (button == 0 && isMouseOverScrollbar(mouseX, mouseY)) {
                float scrollPercent = (float) (mouseY - y) / height;
                scrollAmount = scrollPercent * (contentHeight - height);
                scrollAmount = Math.max(0, Math.min(scrollAmount, contentHeight - height));
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
            if (isMouseOver(mouseX, mouseY)) {
                scrollAmount = Math.max(0, Math.min(scrollAmount - vertical * 10, contentHeight - height));
                return true;
            }
            return false;
        }

        private boolean isMouseOverScrollbar(double mouseX, double mouseY) {
            int scrollbarX = x + width - 8;
            return mouseX >= scrollbarX &&
                    mouseX <= scrollbarX + 8 &&
                    mouseY >= y &&
                    mouseY <= y + height;
        }

        private void renderScrollbar(class_332 context) {
            int scrollbarWidth = 6;
            int scrollbarX = x + width - scrollbarWidth - 2;

            float maxScroll = Math.max(contentHeight - height, 1);
            float scrollProgress = (float) (scrollAmount / maxScroll);
            int scrollbarHeight = (int) ((height * height) / contentHeight);
            scrollbarHeight = Math.max(scrollbarHeight, 32);

            int scrollbarY = y + (int) ((height - scrollbarHeight) * scrollProgress);

            context.method_25296(
                    scrollbarX, y,
                    scrollbarX + scrollbarWidth, y + height,
                    0x00000000, 0x80000000
            );

            context.method_25296(
                    scrollbarX, scrollbarY,
                    scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight,
                    0xFF808080, 0xFF606060
            );
        }
    }
}