// LastWorldConfig.java
package net.xtreamc.booster.util;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class LastWorldConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("booster_last_world.dat");
    private static String lastWorldPath = "";

    public static void save(String worldPath) {
        try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(CONFIG_PATH))) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("worldPath", worldPath);
            class_2507.method_10628(nbt, dos);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String load() {
        if (!Files.exists(CONFIG_PATH)) return "";

        try (DataInputStream dis = new DataInputStream(Files.newInputStream(CONFIG_PATH))) {
            class_2487 nbt = class_2507.method_10627(dis);
            return nbt != null ? nbt.method_10558("worldPath") : "";
        } catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}