package net.xtreamc.booster.integration;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.xtreamc.booster.config.BoosterConfig;

public class ClothConfigIntegration {
    public static class_437 createConfigScreen(class_437 parent) {
        var cfg = BoosterConfig.get();
        ConfigBuilder builder = ConfigBuilder.create()
                .setParentScreen(parent)
                .setTitle(class_2561.method_43471("config.booster.title"));
        builder.setSavingRunnable(cfg::save);

        ConfigEntryBuilder eb = builder.entryBuilder();

        // "All" category
        //ConfigCategory allCat = builder.getOrCreateCategory(Text.translatable("config.booster.category.all"));
        //addAllOptions(allCat, eb, cfg);

        // Separate categories (as before)
        ConfigCategory chatCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.chat"));
        addChatOptions(chatCat, eb, cfg);

        ConfigCategory invCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.inventory"));
        addInventoryOptions(invCat, eb, cfg);

        ConfigCategory deathCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.death"));
        addDeathOptions(deathCat, eb, cfg);

        ConfigCategory contCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.container"));
        addContainerOptions(contCat, eb, cfg);

        ConfigCategory menuCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.game_menu"));
        addGameMenuOptions(menuCat, eb, cfg);

        ConfigCategory rpCat = builder.getOrCreateCategory(class_2561.method_43471("config.booster.category.resource_packs"));
        addResourcePackOptions(rpCat, eb, cfg);

        return builder.build();
    }

    private static void addAllOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addChatOptions(cat, eb, cfg);
        addInventoryOptions(cat, eb, cfg);
        addDeathOptions(cat, eb, cfg);
        addContainerOptions(cat, eb, cfg);
        addGameMenuOptions(cat, eb, cfg);
        addResourcePackOptions(cat, eb, cfg);
    }

    private static void addBoolean(ConfigCategory cat, ConfigEntryBuilder eb,
                                   String key, boolean currentValue,
                                   java.util.function.Consumer<Boolean> setter) {
        BooleanListEntry entry = eb
                .startBooleanToggle(class_2561.method_43471(key), currentValue)
                .setSaveConsumer(setter)
                .build();
        cat.addEntry(entry);
    }

    private static void addChatOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.chatClearButton", cfg.chatClearButton, v -> cfg.chatClearButton = v);
        addBoolean(cat, eb, "config.booster.chatQuickCommands", cfg.chatQuickCommands, v -> cfg.chatQuickCommands = v);
        addBoolean(cat, eb, "config.booster.titleLastServer", cfg.titleLastServer, v -> cfg.titleLastServer = v);
        addBoolean(cat, eb, "config.booster.chatAddCoordinatesButton", cfg.chatAddCoordinatesButton, v -> cfg.chatAddCoordinatesButton = v);
        addBoolean(cat, eb, "config.booster.chatClearTextButton", cfg.chatClearTextButton, v -> cfg.chatClearTextButton = v);
    }

    private static void addInventoryOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.inventorySearch", cfg.inventorySearch, v -> cfg.inventorySearch = v);
        addBoolean(cat, eb, "config.booster.inventoryProgress", cfg.inventoryProgress, v -> cfg.inventoryProgress = v);
        addBoolean(cat, eb, "config.booster.inventoryDropAll", cfg.inventoryDropAll, v -> cfg.inventoryDropAll = v);
        addBoolean(cat, eb, "config.booster.inventoryDropItemMode", cfg.inventoryDropItemMode, v -> cfg.inventoryDropItemMode = v);
        addBoolean(cat, eb, "config.booster.inventoryDropItems", cfg.inventoryDropItems, v -> cfg.inventoryDropItems = v);
    }

    private static void addDeathOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.deathCoordinates", cfg.deathCoordinates, v -> cfg.deathCoordinates = v);
        addBoolean(cat, eb, "config.booster.deathInventory", cfg.deathInventory, v -> cfg.deathInventory = v);
        addBoolean(cat, eb, "config.booster.deathTeleport", cfg.deathTeleport, v -> cfg.deathTeleport = v);
    }

    private static void addContainerOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.containerStealStore", cfg.containerStealStore, v -> cfg.containerStealStore = v);
        addBoolean(cat, eb, "config.booster.containerSearchBar", cfg.containerSearchBar, v -> cfg.containerSearchBar = v);
        addBoolean(cat, eb, "config.booster.containerProgressBar", cfg.containerProgressBar, v -> cfg.containerProgressBar = v);
        addBoolean(cat, eb, "config.booster.containerStealStoreSelected", cfg.containerStealStoreSelcted, v -> cfg.containerStealStoreSelcted = v);
    }

    private static void addGameMenuOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.gameMenuSingleSaveQuitWorld", cfg.gameMenuSingleSaveQuitWorld, v -> cfg.gameMenuSingleSaveQuitWorld = v);
        addBoolean(cat, eb, "config.booster.gameMenuSingleSaveQuitGame", cfg.gameMenuSingleSaveQuitGame, v -> cfg.gameMenuSingleSaveQuitGame = v);
        addBoolean(cat, eb, "config.booster.gameMenuMultiDisconnectQuitWorld", cfg.gameMenuMultiDisconnectQuitWorld, v -> cfg.gameMenuMultiDisconnectQuitWorld = v);
        addBoolean(cat, eb, "config.booster.gameMenuMultiDisconnectQuitGame", cfg.gameMenuMultiDisconnectQuitGame, v -> cfg.gameMenuMultiDisconnectQuitGame = v);
    }

    private static void addResourcePackOptions(ConfigCategory cat, ConfigEntryBuilder eb, BoosterConfig cfg) {
        addBoolean(cat, eb, "config.booster.resourcePackAddAll", cfg.resourcePackAddAll, v -> cfg.resourcePackAddAll = v);
        addBoolean(cat, eb, "config.booster.resourcePackRemoveAll", cfg.resourcePackRemoveAll, v -> cfg.resourcePackRemoveAll = v);
    }
}
