package net.xtreamc.booster.integration;

import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.xtreamc.booster.config.BoosterConfig;

public class YACLIntegration {
    public static class_437 createConfigScreen(class_437 parent) {
        var config = BoosterConfig.get();

        var builder = YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43471("config.booster.title"))
                .save(BoosterConfig.get()::save);

        // טאב "All" - כל ההגדרות
        var allCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.all"));
        addAllOptions(allCategory, config);

        // טאב Chat Features
        var chatCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.chat"));
        addChatOptions(chatCategory, config);

        // טאב Inventory Features
        var inventoryCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.inventory"));
        addInventoryOptions(inventoryCategory, config);

        // טאב Death Features
        var deathCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.death"));
        addDeathOptions(deathCategory, config);

        // טאב Container Features
        var containerCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.container"));
        addContainerOptions(containerCategory, config);

        // טאב Game Menu
        var gameMenuCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.game_menu"));
        addGameMenuOptions(gameMenuCategory, config);

        // טאב Resource Packs
        var resourcePackCategory = ConfigCategory.createBuilder()
                .name(class_2561.method_43471("config.booster.category.resource_packs"));
        addResourcePackOptions(resourcePackCategory, config);

        // הוספת כל הטאבים
        //builder.category(allCategory.build());
        builder.category(chatCategory.build());
        builder.category(inventoryCategory.build());
        builder.category(deathCategory.build());
        builder.category(containerCategory.build());
        builder.category(gameMenuCategory.build());
        builder.category(resourcePackCategory.build());

        return builder.build().generateScreen(parent);
    }

    // פונקציות עזר לפיצול הקטגוריות
    private static void addAllOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addChatOptions(category, config);
        addInventoryOptions(category, config);
        addDeathOptions(category, config);
        addContainerOptions(category, config);
        addGameMenuOptions(category, config);
        addResourcePackOptions(category, config);
    }

    private static void addChatOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "chatClearButton", config.chatClearButton, "config.booster.chatClearButton");
        addBooleanOption(category, "chatQuickCommands", config.chatQuickCommands, "config.booster.chatQuickCommands");
        addBooleanOption(category, "titleLastServer", config.titleLastServer, "config.booster.titleLastServer");
        addBooleanOption(category, "chatAddCoordinatesButton", config.chatAddCoordinatesButton, "config.booster.chatAddCoordinatesButton");
        addBooleanOption(category, "chatClearTextButton", config.chatClearTextButton, "config.booster.chatClearTextButton");
    }

    private static void addInventoryOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "inventorySearch", config.inventorySearch, "config.booster.inventorySearch");
        addBooleanOption(category, "inventoryProgress", config.inventoryProgress, "config.booster.inventoryProgress");
        addBooleanOption(category, "inventoryDropAll", config.inventoryDropAll, "config.booster.inventoryDropAll");
        addBooleanOption(category, "inventoryDropItemMode", config.inventoryDropItemMode, "config.booster.inventoryDropItemMode");
        addBooleanOption(category, "inventoryDropItems", config.inventoryDropItems, "config.booster.inventoryDropItems");
    }

    private static void addDeathOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "deathCoordinates", config.deathCoordinates, "config.booster.deathCoordinates");
        addBooleanOption(category, "deathInventory", config.deathInventory, "config.booster.deathInventory");
        addBooleanOption(category, "deathTeleport", config.deathTeleport, "config.booster.deathTeleport");
    }

    private static void addContainerOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "containerStealStore", config.containerStealStore, "config.booster.containerStealStore");
        addBooleanOption(category, "containerSearchBar", config.containerSearchBar, "config.booster.containerSearchBar");
        addBooleanOption(category, "containerProgressBar", config.containerProgressBar, "config.booster.containerProgressBar");
        addBooleanOption(category, "containerStealStoreSelected", config.containerStealStoreSelcted, "config.booster.containerStealStoreSelected"); // תיקון טעות כתיב
    }

    private static void addGameMenuOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "gameMenuSingleSaveQuitWorld", config.gameMenuSingleSaveQuitWorld, "config.booster.gameMenuSingleSaveQuitWorld");
        addBooleanOption(category, "gameMenuSingleSaveQuitGame", config.gameMenuSingleSaveQuitGame, "config.booster.gameMenuSingleSaveQuitGame");
        addBooleanOption(category, "gameMenuMultiDisconnectQuitWorld", config.gameMenuMultiDisconnectQuitWorld, "config.booster.gameMenuMultiDisconnectQuitWorld");
        addBooleanOption(category, "gameMenuMultiDisconnectQuitGame", config.gameMenuMultiDisconnectQuitGame, "config.booster.gameMenuMultiDisconnectQuitGame");
    }

    private static void addResourcePackOptions(ConfigCategory.Builder category, BoosterConfig config) {
        addBooleanOption(category, "resourcePackAddAll", config.resourcePackAddAll, "config.booster.resourcePackAddAll");
        addBooleanOption(category, "resourcePackRemoveAll", config.resourcePackRemoveAll, "config.booster.resourcePackRemoveAll");
    }

    private static void addBooleanOption(ConfigCategory.Builder category, String fieldName, boolean initialValue, String translationKey) {
        try {
            var option = Option.<Boolean>createBuilder()
                    .name(class_2561.method_43471(translationKey))
                    .binding(
                            initialValue,
                            () -> {
                                try {
                                    return getFieldValue(BoosterConfig.get(), fieldName);
                                } catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            },
                            newValue -> {
                                try {
                                    setFieldValue(BoosterConfig.get(), fieldName, newValue);
                                } catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                    )
                    .controller(BooleanControllerBuilder::create)
                    .build();

            category.option(option);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean getFieldValue(BoosterConfig config, String fieldName) throws Exception {
        return config.getClass().getField(fieldName).getBoolean(config);
    }

    private static void setFieldValue(BoosterConfig config, String fieldName, boolean value) throws Exception {
        config.getClass().getField(fieldName).setBoolean(config, value);
    }
}