package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7919;
import net.xtreamc.booster.client.MultiSelectState;
import net.xtreamc.booster.config.BoosterConfig;
import net.xtreamc.booster.screen.HowToUseScreen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Mixin(class_465.class)
public abstract class ContainerScreenMixin extends class_437 {

    @Final
    @Shadow protected class_1703 handler;
    @Shadow
    protected int x;
    @Shadow
    protected int y;
    @Unique
    private static final int PROGRESS_WIDTH = 100;
    @Unique
    private static final int PROGRESS_HEIGHT = 8;
    @Unique
    private static final int BACKGROUND_COLOR = 0xFF555555; // אפור
    @Unique
    private static final int FOREGROUND_COLOR = 0xFF00FF00; // ירוק

    @Unique
    private class_342 searchField;
    @Unique
    private final List<Integer> matchingSlots = new ArrayList<>();
    @Unique
    private int totalItems = 0;


    @Unique private MultiSelectState stealSelectedState = MultiSelectState.INACTIVE;
    @Unique private MultiSelectState storeSelectedState = MultiSelectState.INACTIVE;
    @Unique private final Set<Integer> selectedContainerSlots = new HashSet<>();
    @Unique private final Set<Integer> selectedInventorySlots = new HashSet<>();

    @Unique private class_4185 stealSelectedButton;
    @Unique private class_4185 storeSelectedButton;

    protected ContainerScreenMixin(class_2561 title) {
        super(title);
    }



    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        // תיקון NPE - בדיקה שהשדה קיים
        if (this.searchField != null && this.searchField.method_25370() && keyCode == 69) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addStealAndStoreButtons(CallbackInfo ci) {
        class_465<?> screen = (class_465<?>) (Object) this;
        class_1703 handler = screen.method_17577();
        class_310 client = class_310.method_1551();

        if (handler instanceof class_1707) {
            class_1707 container = (class_1707) handler;
            int rows = container.method_17388();
            int containerSlots = rows * 9;

            int buttonX, buttonY, fieldX, fieldY, fieldWidth;
            int baseX = this.field_22789 / 2 + 80;
            int baseY = this.field_22790 / 2 - (rows == 6 ? 108 : 81) + 20;
            int yPlus = 69;

            if (rows == 6) {
                buttonX = this.field_22789 / 2;
                buttonY = this.field_22790 / 2 - 108;
                fieldX = this.x + -140;
                fieldY = this.field_22790 / 2 - 110;
                fieldWidth = 130;
                yPlus = yPlus*2;
            } else {
                buttonX = this.field_22789 / 2;
                buttonY = this.field_22790 / 2 - 81;
                fieldX = this.x + 1;
                fieldY = this.field_22790 / 2 - 110;
                fieldWidth = 169;
            }

            if(BoosterConfig.load().containerStealStoreSelcted) {
                this.stealSelectedButton = class_4185.method_46430(class_2561.method_43470("↓*"), b -> handleStealSelected())
                        .method_46434(baseX, baseY, 20, 13)
                        .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.steal_selected")))
                        .method_46431();
                this.method_37063(this.stealSelectedButton);

                this.storeSelectedButton = class_4185.method_46430(class_2561.method_43470("↑*"), b -> handleStoreSelected())
                        .method_46434(baseX, baseY + 16, 20, 13)
                        .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.store_selected")))
                        .method_46431();
                this.method_37063(this.storeSelectedButton);
            }

            this.searchField = new class_342(
                    this.field_22793,
                    fieldX,
                    fieldY,
                    fieldWidth,
                    20,
                    class_2561.method_43470("Search...")
            );

            if(BoosterConfig.load().containerStealStore) {
                // כפתור Steal עם בדיקת נעילה
                this.method_37063(
                        class_4185.method_46430(class_2561.method_43470("↓"), button -> {
                                    for (int slot = 0; slot < containerSlots; slot++) {
                                        if (isSlotLocked(slot)) continue;
                                        clickSlot(client, handler, slot, class_1713.field_7794);
                                    }
                                })
                                .method_46434(buttonX, buttonY, 40, 13)
                                .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.steal")))
                                .method_46431()
                );

                // כפתור Store עם בדיקת נעילה
                this.method_37063(
                        class_4185.method_46430(class_2561.method_43470("↑"), button -> {
                                    for (int slot = containerSlots; slot < containerSlots + 36; slot++) {
                                        if (isSlotLocked(slot)) continue;
                                        clickSlot(client, handler, slot, class_1713.field_7794);
                                    }
                                })
                                .method_46434(buttonX + 41, buttonY, 40, 13)
                                .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.store")))
                                .method_46431()
                );
            }

            if(BoosterConfig.load().containerSearchBar) {
                this.method_37063(this.searchField);
                this.searchField.method_1863(this::updateSearch);
            }

            if (BoosterConfig.load().everyScreenModGuideButton) {
                this.method_37063(class_4185.method_46430(
                                class_2561.method_43470("?"),
                                button -> class_310.method_1551().method_1507(new HowToUseScreen(this))
                        )
                        .method_46434(10, this.field_22790-30, 15, 15)
                        .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.guide")))
                        .method_46431());
            }

            // כפתור Fill Chest's Stacks חדש
            this.method_37063(
                    class_4185.method_46430(class_2561.method_43470("⤴"), button -> handleFillChestStacks())
                            .method_46434(buttonX, buttonY + yPlus, 40, 11)
                            .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.fill_chest")))
                            .method_46431()
            );

            // כפתור Fill Inventory Stacks חדש
            this.method_37063(
                    class_4185.method_46430(class_2561.method_43470("⤵"), button -> handleFillInventoryStacks())
                            .method_46434(buttonX + 41, buttonY + yPlus, 40, 11)
                            .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.fill_inventory")))
                            .method_46431()
            );




        }
    }

    @Unique
    private boolean isSlotLocked(int handlerSlotId) {
        if (!(handler instanceof class_1707)) return false;

        int containerSlots = ((class_1707) handler).method_17388() * 9;

        // המרה מדויקת למיקומי השחקן
        if (handlerSlotId >= containerSlots) {
            int playerSlotId = convertToPlayerSlotId(handlerSlotId, containerSlots);
            return playerSlotId != -1 && BoosterConfig.load().lockedSlots.contains(playerSlotId);
        }
        return false;
    }

    @Unique
    private int convertToPlayerSlotId(int handlerSlotId, int containerSlots) {
        int offset = handlerSlotId - containerSlots;
        if (offset >= 0 && offset < 27) {
            // אינבנטורי ראשי: 9-35
            return offset + 9;
        } else if (offset >= 27 && offset < 36) {
            // הוטבר: 0-8
            return offset - 27;
        }
        return -1;
    }

    @Unique
    private void handleFillChestStacks() {
        if (!(handler instanceof class_1707)) return;
        class_1707 container = (class_1707) handler;
        int containerSlots = container.method_17388() * 9;
        class_310 client = class_310.method_1551();

        for (int chestSlot = 0; chestSlot < containerSlots; chestSlot++) {
            if (isSlotLocked(chestSlot)) continue;
            class_1735 slot = handler.field_7761.get(chestSlot);
            class_1799 chestStack = slot.method_7677();
            if (chestStack.method_7960() || chestStack.method_7947() >= chestStack.method_7914()) continue;

            class_1792 itemType = chestStack.method_7909();
            for (int invSlot = containerSlots; invSlot < containerSlots + 36; invSlot++) {
                if (isSlotLocked(invSlot)) continue;
                class_1735 inv = handler.field_7761.get(invSlot);
                class_1799 invStack = inv.method_7677();

                if (!invStack.method_7960() && invStack.method_7909() == itemType) {
                    clickSlot(client, handler, invSlot, class_1713.field_7794);
                    chestStack = slot.method_7677(); // רענון הסטאק לאחר העברה
                    if (chestStack.method_7947() >= chestStack.method_7914()) break;
                }
            }
        }
    }

    @Unique
    private void handleFillInventoryStacks() {
        if (!(handler instanceof class_1707)) return;
        class_1707 container = (class_1707) handler;
        int containerSlots = container.method_17388() * 9;
        class_310 client = class_310.method_1551();

        for (int invSlot = containerSlots; invSlot < containerSlots + 36; invSlot++) {
            if (isSlotLocked(invSlot)) continue;
            class_1735 slot = handler.field_7761.get(invSlot);
            class_1799 invStack = slot.method_7677();
            if (invStack.method_7960() || invStack.method_7947() >= invStack.method_7914()) continue;

            class_1792 itemType = invStack.method_7909();
            for (int chestSlot = 0; chestSlot < containerSlots; chestSlot++) {
                if (isSlotLocked(chestSlot)) continue;
                class_1735 chest = handler.field_7761.get(chestSlot);
                class_1799 chestStack = chest.method_7677();

                if (!chestStack.method_7960() && chestStack.method_7909() == itemType) {
                    clickSlot(client, handler, chestSlot, class_1713.field_7794);
                    invStack = slot.method_7677(); // רענון הסטאק לאחר העברה
                    if (invStack.method_7947() >= invStack.method_7914()) break;
                }
            }
        }
    }



    @Inject(method = "render", at = @At("TAIL"))
    private void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        // הדגשה וספירת פריטים רק בתיבות
        if (this.handler instanceof class_1707) {
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            // הדגשת סלוטים
            int highlightColor = 0x7700FF00;
            for (int slotId : matchingSlots) {
                class_1735 slot = this.handler.field_7761.get(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, highlightColor);
            }

            // ספירת פריטים (כמות כוללת)
            this.totalItems = 0;
            for (int i = 0; i < containerSlots; i++) {
                class_1799 stack = this.handler.field_7761.get(i).method_7677();
                this.totalItems += stack.method_7947();
            }

            // הצגת הספירה
            class_2561 countText = class_2561.method_43470("Items: " + this.totalItems);
            context.method_27535(
                    this.field_22793,
                    countText,
                    this.x + -140,
                    this.field_22790 / 2 - 70,
                    0xFFFFFF
            );
        }

        if (this.handler instanceof class_1707) {
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            // חישוב הפרוגרס
            int maxItems = containerSlots * 64; // מקסימום אפשרי (כל סלוט מלא 64)
            float progress = (float) totalItems / maxItems;
            int progressFilled = (int) (PROGRESS_WIDTH * progress);

            // מיקום הפרוגרס בר - פינה שמאלית עליונה
            int progressX = this.x + -140 ;
            int progressY = this.field_22790 / 2 - 80;

            if(BoosterConfig.load().containerProgressBar) {
                // ציור הרקע
                context.method_25294(
                        progressX,
                        progressY,
                        progressX + PROGRESS_WIDTH,
                        progressY + PROGRESS_HEIGHT,
                        BACKGROUND_COLOR
                );

                // ציור ההתקדמות
                if(progressFilled > 0) {
                    context.method_25294(
                            progressX,
                            progressY,
                            progressX + progressFilled,
                            progressY + PROGRESS_HEIGHT,
                            FOREGROUND_COLOR
                    );
                }

                // הוספת טקסט עם אחוזים
                class_2561 progressText = class_2561.method_43470(String.format("%.1f%%", progress * 100));
                context.method_27535(
                        this.field_22793,
                        progressText,
                        progressX + PROGRESS_WIDTH + 5,
                        progressY,
                        0xFFFFFF
                );
            }



            // הדגשת סלוטים נעולים של השחקן בלבד
            Set<Integer> lockedSlots = BoosterConfig.load().lockedSlots;
            for (int playerSlotId : lockedSlots) {
                int handlerSlotId = convertToHandlerSlotId(playerSlotId, containerSlots);
                if (handlerSlotId != -1 && handlerSlotId < this.handler.field_7761.size()) {
                    class_1735 slot = this.handler.method_7611(handlerSlotId);
                    context.method_25294(
                            this.x + slot.field_7873,
                            this.y + slot.field_7872,
                            this.x + slot.field_7873 + 16,
                            this.y + slot.field_7872 + 16,
                            0x66FFA500 // כתום שקוף
                    );
                }
            }
        }
    }

    @Unique
    private int convertToHandlerSlotId(int playerSlotId, int containerSlots) {
        if (playerSlotId >= 9 && playerSlotId < 36) {
            // אינבנטורי ראשי
            return containerSlots + (playerSlotId - 9);
        } else if (playerSlotId >= 0 && playerSlotId < 9) {
            // הוטבר
            return containerSlots + 27 + playerSlotId;
        }
        return -1;
    }


    @Unique
    private void handleStealSelected() {

        if (stealSelectedState == MultiSelectState.INACTIVE) {
            stealSelectedState = MultiSelectState.SELECTING;
            stealSelectedButton.method_25355(class_2561.method_43470("✅"));
            stealSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.accept")));
            selectedContainerSlots.clear();
        } else {
            class_310 client = class_310.method_1551();
            for (int slotId : selectedContainerSlots) {
                if (isSlotLocked(slotId)) continue;
                clickSlot(client, this.handler, slotId, class_1713.field_7794);
            }
            stealSelectedState = MultiSelectState.INACTIVE;
            stealSelectedButton.method_25355(class_2561.method_43470("↓*"));
            stealSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.steal_selected")));
            selectedContainerSlots.clear();
        }
    }

    @Unique
    private void handleStoreSelected() {
        if (storeSelectedState == MultiSelectState.INACTIVE) {
            storeSelectedState = MultiSelectState.SELECTING;
            storeSelectedButton.method_25355(class_2561.method_43470("✅"));
            storeSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.accept")));
            selectedInventorySlots.clear();
        } else {
            class_310 client = class_310.method_1551();
            for (int slotId : selectedInventorySlots) {
                if (isSlotLocked(slotId)) continue;
                clickSlot(client, this.handler, slotId, class_1713.field_7794);
            }
            storeSelectedState = MultiSelectState.INACTIVE;
            storeSelectedButton.method_25355(class_2561.method_43470("↑*"));
            storeSelectedButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.store_selected")));
            selectedInventorySlots.clear();
        }
    }

    @Unique
    private void updateSearch(String query) {
        if (this.handler instanceof class_1707) {
            String searchQuery = query.toLowerCase();
            this.matchingSlots.clear();
            class_1707 container = (class_1707) this.handler;
            int containerSlots = container.method_17388() * 9;

            for (int i = 0; i < containerSlots; i++) {
                class_1799 stack = this.handler.field_7761.get(i).method_7677();
                if (!stack.method_7960() &&
                        stack.method_7964().getString().toLowerCase().contains(searchQuery)) {
                    this.matchingSlots.add(i);
                }
            }
        }
    }

    @Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        // בדיקה שהמסך הוא תיבה ולא אינוונטור רגיל
        if (!(handler instanceof class_1707)) return;

        class_465<?> screen = (class_465<?>)(Object)this;
        class_1735 focused = ((HandledScreenAccessor) screen).getFocusedSlot();
        if (focused == null || !focused.method_7681()) return;

        int slotId = this.handler.field_7761.indexOf(focused);
        int containerSlots = ((class_1707)handler).method_17388() * 9;

        // טיפול בלחיצות רק במצב בחירה פעיל
        if (stealSelectedState == MultiSelectState.SELECTING && slotId < containerSlots) {
            if (!selectedContainerSlots.remove(slotId)) {
                selectedContainerSlots.add(slotId);
            }
            cir.setReturnValue(true);
        } else if (storeSelectedState == MultiSelectState.SELECTING && slotId >= containerSlots) {
            if (!selectedInventorySlots.remove(slotId)) {
                selectedInventorySlots.add(slotId);
            }
            cir.setReturnValue(true);
        }
    }



    // 8. הדגשת הסלוטים שנבחרו בצבע אדום
    @Inject(method = "render", at = @At("TAIL"))
    private void renderSelectionHighlights(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!(handler instanceof class_1707)) return;

        // אדום שקוף ל־Steal Selected
        if (stealSelectedState == MultiSelectState.SELECTING) {
            for (int slotId : selectedContainerSlots) {
                class_1735 slot = this.handler.method_7611(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, 0x44FF0000);
            }
        }
        // אדום שקוף ל־Store Selected
        if (storeSelectedState == MultiSelectState.SELECTING) {
            for (int slotId : selectedInventorySlots) {
                class_1735 slot = this.handler.method_7611(slotId);
                context.method_25294(this.x + slot.field_7873, this.y + slot.field_7872, this.x + slot.field_7873 + 16, this.y + slot.field_7872 + 16, 0x44FF0000);
            }
        }
    }

    @Unique
    private void clickSlot(class_310 client, class_1703 handler, int slotId, class_1713 actionType) {
        client.field_1761.method_2906(
                handler.field_7763, // מזהה של ה־screen handler
                slotId,
                0, // button – 0 = שמאל, 1 = ימין
                actionType,
                client.field_1724
        );
    }
}