// CraftingScreenMixin.java - Fabric 1.21.4 with Loom 1.10.2 and Yarn mappings

package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_7919;
import net.xtreamc.booster.config.BoosterConfig;
import net.xtreamc.booster.screen.HowToUseScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_479.class)
public abstract class CraftingScreenMixin extends class_465<class_1714> {


    public CraftingScreenMixin(class_1714 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Unique
    private class_1799 recipeReference = class_1799.field_8037;

    @Unique
    private boolean isSameItem(class_1799 a, class_1799 b) {
        if (a == null || b == null) return false;
        if (!a.method_31574(b.method_7909())) return false;
        return class_1799.method_7973(a, b); // אם אתה רוצה גם לבדוק NBT
    }


    @Inject(method = "init", at = @At("TAIL"))
    private void onInit(CallbackInfo ci) {
        int buttonX = this.field_2776 + this.field_2792 - 20;
        int buttonY = this.field_2800 + 5;

        class_4185 craftAllButton = class_4185.method_46430(
                        class_2561.method_43470("∞"),
                        btn -> craftAll()
                ).method_46434(buttonX, buttonY, 18, 18)
                .method_46436(class_7919.method_47407(class_2561.method_43471("gui.crafting.craft_all")))
                .method_46431();

        this.method_37063(craftAllButton);

        if (BoosterConfig.load().everyScreenModGuideButton) {
            this.method_37063(class_4185.method_46430(
                            class_2561.method_43470("?"),
                            button -> class_310.method_1551().method_1507(new HowToUseScreen(this))
                    )
                    .method_46434(10, this.field_22790-30, 15, 15)
                    .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.guide")))
                    .method_46431());
        }
    }

    @Unique
    private class_1799[] getRecipePattern() {
        class_1799[] pattern = new class_1799[9];
        for (int i = 0; i < 9; i++) {
            pattern[i] = field_2797.method_7611(i + 1).method_7677().method_7972(); // 1–9 הם הגריד
        }
        return pattern;
    }


    @Unique
    private void craftAll() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null) return;

        class_1799[] recipePattern = getRecipePattern();
        if (recipePattern == null) return;

        craftSingle(recipePattern, 0);

    }

    @Unique
    private void craftSingle(class_1799[] pattern, int attempt) {
        if (attempt >= 100) return;

        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null) return;

        // שלב ראשון: ריקון הגריד
        client.execute(() -> {
            for (int i = 1; i <= 9; i++) {
                class_1735 slot = field_2797.method_7611(i);
                if (slot.method_7681()) {
                    client.field_1761.method_2906(field_2797.field_7763, i, 1, class_1713.field_7794, client.field_1724);
                }
            }

            // המתן טיק אחד לפני שממלאים
            client.method_20493(() -> {
                fillGridFromInventory(pattern);

                // המתן טיק נוסף לפני שלוקחים את התוצאה
                client.method_20493(() -> {
                    class_1735 resultSlot = field_2797.method_7611(0);
                    if (!resultSlot.method_7681()) return;

                    client.field_1761.method_2906(field_2797.field_7763, 0, 0, class_1713.field_7794, client.field_1724);

                    // אם אפשר להכין עוד
                    if (canCraftAgain(pattern)) {
                        client.method_20493(() -> craftSingle(pattern, attempt + 1));
                    }
                });
            });
        });
    }


    @Unique
    private boolean canCraftAgain(class_1799[] pattern) {
        for (class_1799 needed : pattern) {
            if (needed.method_7960()) continue;

            boolean found = false;
            for (int i = 10; i < field_2797.field_7761.size(); i++) {
                class_1735 slot = field_2797.method_7611(i);
                if (slot.method_7681() && isSameItem(slot.method_7677(), needed)) {
                    found = true;
                    break;
                }
            }
            if (!found) return false;
        }
        return true;
    }


    @Unique
    private void fillCraftingGrid() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null || recipeReference.method_7960()) return;

        for (int invSlot = 10; invSlot < this.field_2797.field_7761.size(); invSlot++) {
            class_1735 slot = this.field_2797.method_7611(invSlot);
            if (!slot.method_7681()) continue;

            class_1799 stack = slot.method_7677();
            if (!isSameItem(stack, recipeReference)) continue;


            for (int gridSlot = 1; gridSlot <= 9; gridSlot++) {
                class_1735 grid = this.field_2797.method_7611(gridSlot);
                if (!grid.method_7681()) {
                    client.field_1761.method_2906(this.field_2797.field_7763, invSlot, 0, class_1713.field_7794, client.field_1724);
                    break;
                }
            }
        }
    }

    @Unique
    private void fillGridFromInventory(class_1799[] pattern) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null) return;

        // ננקה את הגריד קודם
        for (int i = 1; i <= 9; i++) {
            class_1735 gridSlot = field_2797.method_7611(i);
            if (gridSlot.method_7681()) {
                client.field_1761.method_2906(field_2797.field_7763, i, 1, class_1713.field_7794, client.field_1724);
            }
        }

        // נעבור לפי הפטרן
        for (int i = 0; i < 9; i++) {
            class_1799 required = pattern[i];
            if (required.method_7960()) continue;

            // חיפוש באינוונטורי
            for (int invSlot = 10; invSlot < field_2797.field_7761.size(); invSlot++) {
                class_1735 inv = field_2797.method_7611(invSlot);
                if (!inv.method_7681()) continue;
                if (isSameItem(inv.method_7677(), required)) {
                    // נזיז מהאינוונטורי לגריד (slot i+1)
                    client.field_1761.method_2906(field_2797.field_7763, invSlot, 0, class_1713.field_7790, client.field_1724);
                    client.field_1761.method_2906(field_2797.field_7763, i + 1, 0, class_1713.field_7790, client.field_1724);
                    break;
                }
            }
        }
    }
}