package net.xtreamc.booster.mixin.client;

import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import net.xtreamc.booster.client.DropState;
import net.xtreamc.booster.client.LockState;
import net.xtreamc.booster.client.MultiDropState;
import net.xtreamc.booster.config.BoosterConfig;
import net.xtreamc.booster.screen.HowToUseScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Mixin(class_490.class)
public abstract class InventoryScreenMixin extends class_465<class_1723> {

    @Unique
    private DropState dropState = DropState.INACTIVE;
    @Unique private static final int PROGRESS_WIDTH = 100;

    @Unique private static final int PROGRESS_HEIGHT = 8;
    @Unique private static final int BACKGROUND_COLOR = 0xFF555555;
    @Unique private static final int FOREGROUND_COLOR = 0xFF00FF00;

    @Unique private static final class_2561 TEXT_ITEMS = class_2561.method_43471("booster.inventory.items");
    @Unique
    private LockState lockState = LockState.INACTIVE;

    @Unique
    private final Set<Integer> tempLockedSlots = new HashSet<>();

    @Unique
    private class_342 searchField;
    @Unique
    private final List<Integer> matchingSlots = new ArrayList<>();
    @Unique
    private MultiDropState multiDropState = MultiDropState.INACTIVE;
    @Unique
    private final Set<Integer> selectedSlots = new HashSet<>();

    @Unique
    private class_4185 dropItemsButton;

    @Unique
    private class_4185 lockButton;





    @Unique
    private class_1799 targetItem = class_1799.field_8037;


    @Unique
    private boolean dropItemMode = false;

    @Unique
    private class_4185 dropAllButton;
    @Unique
    private class_4185 dropItemButton;
    @Unique private class_4185 sortButton;

    public InventoryScreenMixin() {
        super(null, new class_1661(null), class_2561.method_30163(""));
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addButtons(CallbackInfo ci) {
        // Drop All (כולל הוטבר)
        dropAllButton = class_4185.method_46430(class_2561.method_43470("➤"), button -> {
            for(int slotId = 9; slotId <= 44; slotId++) {
                if (BoosterConfig.load().lockedSlots.contains(slotId)) continue;
                this.field_22787.field_1761.method_2906(field_2797.field_7763, slotId, 1, class_1713.field_7795, this.field_22787.field_1724);
            }
        }).method_46434(this.field_2776 + 125, this.field_2800 + 55, 22, 13).method_46431();

        // Drop Item Mode
        dropItemButton = class_4185.method_46430(getDropButtonText(), button -> handleDropButtonPress())
                .method_46434(this.field_2776 + 148, this.field_2800 + 55, 22, 13)
                .method_46431();

        //sortButton = ButtonWidget.builder(TEXT_SORT, button -> sortInventory())
        //        .dimensions(this.x + 125, this.y + 80, 46, 13)
        //        .build();

        if(BoosterConfig.load().inventoryLockSlots) {
            this.lockButton = class_4185.method_46430(class_2561.method_43470("🔒"), button -> handleLockButton())
                    .method_46434(this.field_2776 + 148, this.field_2800 + 69, 22, 13)
                    .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.lock")))
                    .method_46431();
            this.method_37063(lockButton);
        }

        this.searchField = new class_342(
                this.field_22793,
                this.field_2776 -120, // מיקום צד שמאל
                this.field_2800 - 28, // מעל האינבנטורי
                120, // רוחב
                20, // גובה
                class_2561.method_43471("booster.search.placeholder")
        );

        this.dropItemsButton = class_4185.method_46430(
                        class_2561.method_43471("booster.button.drop_items"),
                        button -> handleDropItems()
                )
                .method_46434(this.field_2776 + 125, this.field_2800 + 69, 22, 13)
                .method_46431();

        if(BoosterConfig.load().inventoryDropAll) {
            this.method_37063(dropAllButton);
        }

        if (BoosterConfig.load().everyScreenModGuideButton) {
            this.method_37063(class_4185.method_46430(
                            class_2561.method_43470("?"),
                            button -> class_310.method_1551().method_1507(new HowToUseScreen(this))
                    )
                    .method_46434(10, this.field_22790-30, 15, 15)
                    .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.guide")))
                    .method_46431());
        }

        if(BoosterConfig.load().inventoryDropItemMode) {
            this.method_37063(dropItemButton);
        }

        if(BoosterConfig.load().inventoryDropItems) {
            this.method_37063(dropItemsButton);
        }

        if(BoosterConfig.load().inventorySearch) {
            this.method_37063(this.searchField);
            this.searchField.method_1863(this::updateSearch);
        }







        //this.addDrawableChild(sortButton);
    }

    @Unique
    private void handleLockButton() {
        BoosterConfig config = BoosterConfig.load();
        if (lockState == LockState.INACTIVE) {
            lockState = LockState.SELECTING;
            tempLockedSlots.clear();
            tempLockedSlots.addAll(config.lockedSlots);
            lockButton.method_25355(class_2561.method_43470("✅"));
            lockButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.accept")));
        } else {
            lockState = LockState.INACTIVE;
            config.lockedSlots = new HashSet<>(tempLockedSlots);
            config.save();
            lockButton.method_25355(class_2561.method_43470("🔒"));
            lockButton.method_47400(class_7919.method_47407(class_2561.method_43471("booster.button.lock")));
        }
    }

    @Unique
    private void handleDropItems() {
        switch (multiDropState) {
            case INACTIVE:
                multiDropState = MultiDropState.SELECTING;
                dropItemsButton.method_25355(class_2561.method_43471("booster.button.click_items"));
                break;
            case SELECTING:
                multiDropState = MultiDropState.CONFIRMING;
                dropItemsButton.method_25355(class_2561.method_43471("booster.button.accept"));
                break;
            case CONFIRMING:
                dropSelectedItems();
                resetDropItemsMode();
                break;
        }
    }

    @Unique
    private void dropSelectedItems() {
        if(field_22787 == null || field_22787.field_1724 == null) return;

        for(int slotId : selectedSlots) {
            if (BoosterConfig.load().lockedSlots.contains(slotId)) continue;
            field_22787.field_1761.method_2906(
                    field_2797.field_7763,
                    slotId,
                    1,
                    class_1713.field_7795,
                    field_22787.field_1724
            );
        }
    }

    @Unique
    private void resetDropItemsMode() {
        multiDropState = MultiDropState.INACTIVE;
        selectedSlots.clear();
        dropItemsButton.method_25355(class_2561.method_43471("booster.button.drop_items"));
    }


    @Unique
    private void updateSearch(String query) {
        matchingSlots.clear();
        String searchQuery = query.toLowerCase();

        // סרוק את כל 36 הסלוטים (0-35) - כולל הוטבר ואינבנטורי ראשי
        for (int slot = 0; slot < 36; slot++) {
            class_1799 stack = this.field_2797.method_7611(slot).method_7677();
            if (!stack.method_7960() &&
                    stack.method_7964().getString().toLowerCase().contains(searchQuery)) {
                matchingSlots.add(slot);
            }
        }
    }




    @Inject(method = "render", at = @At("TAIL"))
    private void renderOverlay(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if(BoosterConfig.load().inventoryProgress) {
            renderInventoryProgress(context);
        }


        if(dropState == DropState.CONFIRMING && !targetItem.method_7960()) {
            for(class_1735 slot : this.field_2797.field_7761) {
                if(isValidSlot(slot) && class_1799.method_7984(slot.method_7677(), targetItem)) {
                    context.method_25294(
                            this.field_2776 + slot.field_7873,
                            this.field_2800 + slot.field_7872,
                            this.field_2776 + slot.field_7873 + 16,
                            this.field_2800 + slot.field_7872 + 16,
                            0x7700FF00
                    );
                }
            }
        }

        int highlightColor = 0x7700FF00;
        for (int slotId : matchingSlots) {
            class_1735 slot = this.field_2797.field_7761.get(slotId);
            context.method_25294(
                    this.field_2776 + slot.field_7873,
                    this.field_2800 + slot.field_7872,
                    this.field_2776 + slot.field_7873 + 16,
                    this.field_2800 + slot.field_7872 + 16,
                    highlightColor
            );
        }

        if(multiDropState != MultiDropState.INACTIVE) {
            for(int slotId : selectedSlots) {
                class_1735 slot = this.field_2797.field_7761.get(slotId);
                context.method_25294(
                        this.field_2776 + slot.field_7873,
                        this.field_2800 + slot.field_7872,
                        this.field_2776 + slot.field_7873 + 16,
                        this.field_2800 + slot.field_7872 + 16,
                        0x44FF0000 // אדום שקוף
                );
            }
        }

        Set<Integer> lockedSlotsToHighlight = lockState == LockState.SELECTING ? tempLockedSlots : BoosterConfig.load().lockedSlots;
        for (int slotId : lockedSlotsToHighlight) {
            class_1735 slot = this.field_2797.field_7761.get(slotId);
            if (slot != null) {
                context.method_25294(
                        this.field_2776 + slot.field_7873,
                        this.field_2800 + slot.field_7872,
                        this.field_2776 + slot.field_7873 + 16,
                        this.field_2800 + slot.field_7872 + 16,
                        0x66FFA500 // כתום עם שקיפות
                );
            }
        }
    }

    @Unique
    private class_2561 getDropButtonText() {
        return switch (dropState) {
            case INACTIVE -> class_2561.method_43471("booster.button.drop_item_mode");
            case SELECTING_ITEM -> class_2561.method_43471("booster.button.click_item");
            case CONFIRMING -> class_2561.method_43471("booster.button.accept");
        };
    }

    @Unique
    private void renderInventoryProgress(class_332 context) {
        class_1661 inv = this.field_22787.field_1724.method_31548();
        int totalItems = 0;
        for(class_1799 stack : inv.field_7547) {
            totalItems += stack.method_7947();
        }

        int maxItems = 27 * 64; // 27 סלוטים באינבנטורי ראשי
        float progress = (float) totalItems / maxItems;

        // מיקום הפרוגרס בר
        int barX = this.field_2776 + 10;
        int barY = this.field_2800 - 15;

        // ציור הרקע
        context.method_25294(barX, barY, barX + PROGRESS_WIDTH, barY + PROGRESS_HEIGHT, BACKGROUND_COLOR);

        // ציור ההתקדמות
        if(progress > 0) {
            context.method_25294(barX, barY, barX + (int)(PROGRESS_WIDTH * progress), barY + PROGRESS_HEIGHT, FOREGROUND_COLOR);
        }

        // טקסט ספירת פריטים
        class_2561 itemsText = TEXT_ITEMS.method_27661().method_27693(String.valueOf(totalItems));
        context.method_27535(field_22793, itemsText, barX, barY - 12, 0xFFFFFF);
    }

    @Unique
    private void sortInventory() {
        if (this.field_22787.field_1724 == null || this.field_22787.field_1761 == null) return;

        class_1661 inv = this.field_22787.field_1724.method_31548();
        List<class_1799> items = new ArrayList<>();

        // איסוף ואיפוס פריטים
        for (int slot = 9; slot < 36; slot++) {
            class_1799 stack = inv.method_5438(slot);
            if (!stack.method_7960()) {
                items.add(stack.method_7972());
                this.swapSlots(slot, findEmptySlot());
            }
        }

        // מיון אלפביתי לפי שם הפריט
        items.sort((stack1, stack2) -> {
            String name1 = stack1.method_7960() ? "" : stack1.method_7964().getString();
            String name2 = stack2.method_7960() ? "" : stack2.method_7964().getString();
            return name1.compareToIgnoreCase(name2);
        });

        // מיקום מחדש
        int targetSlot = 9;
        for (class_1799 stack : items) {
            if (stack.method_7960()) continue;

            int tempSlot = findEmptySlot();
            if (tempSlot == -1) break;

            this.swapSlots(tempSlot, targetSlot++);
        }
    }



    @Unique
    private int findEmptySlot() {
        class_1661 inv = this.field_22787.field_1724.method_31548();
        for (int slot = 9; slot < 36; slot++) {
            if (inv.method_5438(slot).method_7960()) {
                return slot;
            }
        }
        return -1;
    }

    @Unique
    private void swapSlots(int from, int to) {
        if (from == -1 || to == -1) return;

        // פעולת החלפה בין סלוטים
        this.field_22787.field_1761.method_2906(
                this.field_2797.field_7763,
                from,
                0,
                class_1713.field_7790,
                this.field_22787.field_1724
        );

        this.field_22787.field_1761.method_2906(
                this.field_2797.field_7763,
                to,
                0,
                class_1713.field_7790,
                this.field_22787.field_1724
        );
    }

    @Unique
    private void handleDropButtonPress() {
        switch (dropState) {
            case INACTIVE -> {
                dropState = DropState.SELECTING_ITEM;
                this.dropItemButton.method_25355(getDropButtonText());
            }
            case SELECTING_ITEM -> {
                // אם המשתמש חזר למצב בחירה ללא בחירת פריט
                dropState = DropState.INACTIVE;
                this.dropItemButton.method_25355(getDropButtonText());
            }
            case CONFIRMING -> {
                dropAllMatchingItems();
                dropState = DropState.INACTIVE;
                this.dropItemButton.method_25355(getDropButtonText());
            }
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if(dropState == DropState.SELECTING_ITEM) {
            if(this.field_2787 != null && this.field_2787.method_7681()) {
                this.targetItem = this.field_2787.method_7677().method_7972();
                dropState = DropState.CONFIRMING;
                this.dropItemButton.method_25355(getDropButtonText());
                return true; // חסום פעולת עכבר רגילה
            }
        }

        if(multiDropState == MultiDropState.SELECTING) {
            if(this.field_2787 != null && this.field_2787.method_7681()) {
                int slotId = this.field_2787.field_7874;
                if(selectedSlots.contains(slotId)) {
                    selectedSlots.remove(slotId);
                } else {
                    selectedSlots.add(slotId);
                }
                return true;
            }
        }

        if (lockState == LockState.SELECTING) {
            class_1735 focusedSlot = this.field_2787;
            if (focusedSlot != null) { // הורדנו את הבדיקה אם יש פריט
                int slotId = focusedSlot.field_7874;
                if (tempLockedSlots.contains(slotId)) {
                    tempLockedSlots.remove(slotId);
                } else {
                    tempLockedSlots.add(slotId);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Unique
    private boolean isValidSlot(class_1735 slot) {
        // כולל את כל הסלוטים של השחקן (0-35: הוטבר + אינבנטורי ראשי)
        assert this.field_22787.field_1724 != null;
        return slot.field_7871 == this.field_22787.field_1724.method_31548()
                && slot.field_7874 >= 0
                && slot.field_7874 < 36;
    }

    @Unique
    private void drawHighlight(class_332 context, class_1735 slot) {
        int x = this.field_2776 + slot.field_7873;
        int y = this.field_2800 + slot.field_7872;
        context.method_25294(x, y, x + 16, y + 16, 0x8800FF00); // ירוק שקוף
    }

    @Unique
    private void dropAllMatchingItems() {
        if(this.field_22787 == null || this.field_22787.field_1724 == null) return;

        for(int slotId = 0; slotId < 36; slotId++) {
            if (BoosterConfig.load().lockedSlots.contains(slotId)) continue;
            class_1799 stack = this.field_22787.field_1724.method_31548().method_5438(slotId);
            if(class_1799.method_7984(stack, targetItem)) {
                this.field_22787.field_1761.method_2906(
                        field_2797.field_7763,
                        slotId,
                        1,
                        class_1713.field_7795,
                        this.field_22787.field_1724
                );
            }
        }
    }

    @Unique
    private void resetDropMode() {
        dropState = DropState.INACTIVE;
        targetItem = class_1799.field_8037;
    }



    //@Inject(method = "close", at = @At("HEAD")) // שם מתודה מעודכן
    //private void resetOnClose(CallbackInfo ci) {
    //    resetDropMode();
    //}
}
