package net.xtreamc.booster.mixin.client;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import net.minecraft.class_9112;
import net.xtreamc.booster.config.BoosterConfig;
import net.xtreamc.booster.screen.HowToUseScreen;
import net.xtreamc.booster.util.LastServerConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@Mixin(class_500.class)
public abstract class MultiplayerScreenMixin extends class_437 {

    protected MultiplayerScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addUIElements(CallbackInfo ci) {
        addLastServerButton();
    }

    @Unique
    private void addLastServerButton() {
        String lastAddress = LastServerConfig.load();

        this.method_37063(
                class_4185.method_46430(
                                class_2561.method_43470("Last Server"),
                                button -> connectToLastServer(lastAddress)
                        )
                        .method_46436(class_7919.method_47407(class_2561.method_43470("Connect to Last Server")))
                        .method_46434(5, 5, 100, 20)
                        .method_46431()
        );

        if (BoosterConfig.load().everyScreenModGuideButton) {
            this.method_37063(class_4185.method_46430(
                            class_2561.method_43470("?"),
                            button -> class_310.method_1551().method_1507(new HowToUseScreen(this))
                    )
                    .method_46434(10, this.field_22790-30, 15, 15)
                    .method_46436(class_7919.method_47407(class_2561.method_43471("booster.button.guide")))
                    .method_46431());
        }
    }

    @Unique
    private void connectToLastServer(String address) {
        if (!address.isEmpty()) {
            assert this.field_22787 != null;
            class_412.method_36877(
                    this,
                    this.field_22787,
                    class_639.method_2950(address),
                    new class_642("Last Server", address, class_642.class_8678.field_45611),
                    false,
                    new class_9112(Map.of())
            );
        }
    }
}