package net.xtreamc.booster.mixin.client;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.xtreamc.booster.screen.ConfigScreen;
import net.xtreamc.booster.screen.ConfigSelectionScreen;
import net.xtreamc.booster.screen.ErrorScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.awt.*;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;

@Mixin(class_429.class)
public abstract class OptionsScreenMixin extends class_437 {

    protected OptionsScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method = "init", at = @At("TAIL"))
    private void addButtons(CallbackInfo ci) {

        int baseY = this.field_22790 / 6 + 72 - 6;
        // כפתור סקרינשוטים
        this.method_37063(class_4185.method_46430(
                        class_2561.method_43471("options.booster.open_screenshots"),
                        button -> openScreenshotsFolder()
                )
                .method_46434(this.field_22789 / 2 + 5, 55, 150, 20)
                .method_46431());


        this.method_37063(class_4185.method_46430(
                        class_2561.method_30163("Booster ⚙"),
                        b -> class_310.method_1551().method_1507(new ConfigSelectionScreen(this))
                )
                .method_46434(this.field_22789 / 2 - 155, 55, 150, 20)
                .method_46431());
    }

    @Unique
    private void openScreenshotsFolder() {
        File screenshotDir = Paths.get(
                class_310.method_1551().field_1697.getAbsolutePath(),
                "screenshots"
        ).toFile();

        try {
            if (!screenshotDir.exists()) {
                screenshotDir.mkdirs();
            }

            // בדיקה אם המערכת תומכת ב-Desktop API
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                Desktop.getDesktop().open(screenshotDir);
            } else {
                // פתיחה דרך פקודות מערכת
                openViaTerminal(screenshotDir);
            }
        } catch (IOException | UnsupportedOperationException e) {
            class_310.method_1551().method_1507(new ErrorScreen(
                    class_2561.method_43471("error.booster.folder_failed"),
                    class_2561.method_43470(e.getMessage())
            ));
        }
    }

    @Unique
    private void openViaTerminal(File dir) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();
        Runtime rt = Runtime.getRuntime();

        if (os.contains("win")) {
            rt.exec("explorer \"" + dir.getAbsolutePath() + "\"");
        } else if (os.contains("mac")) {
            rt.exec("open \"" + dir.getAbsolutePath() + "\"");
        } else if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
            rt.exec("xdg-open \"" + dir.getAbsolutePath() + "\"");
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + os);
        }
    }


}