// ב-path: src/main/java/net/xtreamc/booster/screen/ConfigScreen.java
package net.xtreamc.booster.screen;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.xtreamc.booster.config.BoosterConfig;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ConfigScreen extends class_437 {
    private final class_437 parent;
    private BoosterConfig config;
    private ScrollableWidget scrollable;
    private final List<ConfigEntry> entries = new ArrayList<>();

    public ConfigScreen(class_437 parent) {
        super(class_2561.method_30163("Booster Config"));
        this.parent = parent;
        this.config = BoosterConfig.load();

        if (this.config == null) {
            this.config = new BoosterConfig();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        // הוספת הכפתור "שמור" כ-widget רגיל
        this.method_37063(class_4185.method_46430(class_2561.method_30163("Save"), b -> {
            config.save();
            class_310.method_1551().method_1507(parent);
        }).method_46434(field_22789 / 2 +61, field_22790 - 30, 100, 20).method_46431());

        // יצירת הכפתורים בתוך ScrollableWidget והוספתם כילדים
        createConfigEntries();
        this.scrollable = new ScrollableWidget(
                this.field_22789 / 2 - 170, // שמירה על ריכוז על ידי הזזה שמאלה ב-10
                30,
                340, // הגדלת הרוחב ב-20
                this.field_22790 - 60, // גובה מקסימלי כדי לא להגיע לכפתור ה-Save
                calculateTotalContentHeight()
        );
    }

    private void createConfigEntries() {
        entries.clear();
        entries.add(new CategoryHeader("Chat Features"));
        entries.add(new CheckboxEntry("Clear Chat Button", config.chatClearButton, v -> config.chatClearButton = v));
        entries.add(new CheckboxEntry("Quick Commands", config.chatQuickCommands, v -> config.chatQuickCommands = v));
        entries.add(new CheckboxEntry("Add Coordinates Button", config.chatAddCoordinatesButton, v -> config.chatAddCoordinatesButton = v));
        entries.add(new CheckboxEntry("Clear Text Button", config.chatClearTextButton, v -> config.chatClearTextButton = v));

        entries.add(new CategoryHeader("Death Features"));
        entries.add(new CheckboxEntry("Show Coordinates", config.deathCoordinates, v -> config.deathCoordinates = v));
        entries.add(new CheckboxEntry("View Inventory", config.deathInventory, v -> config.deathInventory = v));
        entries.add(new CheckboxEntry("Teleport Button", config.deathTeleport, v -> config.deathTeleport = v));

        entries.add(new CategoryHeader("Inventory Features"));
        entries.add(new CheckboxEntry("Item Search", config.inventorySearch, v -> config.inventorySearch = v));
        entries.add(new CheckboxEntry("Progress Bar", config.inventoryProgress, v -> config.inventoryProgress = v));
        entries.add(new CheckboxEntry("Drop All Button", config.inventoryDropAll, v -> config.inventoryDropAll = v));
        entries.add(new CheckboxEntry("Drop Item Mode", config.inventoryDropItemMode, v -> config.inventoryDropItemMode = v));
        entries.add(new CheckboxEntry("Drop Items Button", config.inventoryDropItems, v -> config.inventoryDropItems = v));
        entries.add(new CheckboxEntry("Lock Slots Button", config.inventoryLockSlots, v -> config.inventoryLockSlots = v));


        entries.add(new CategoryHeader("Container Features"));
        entries.add(new CheckboxEntry("Steal/Store Buttons", config.containerStealStore, v -> config.containerStealStore = v));
        entries.add(new CheckboxEntry("Search Bar", config.containerSearchBar, v -> config.containerSearchBar = v));
        entries.add(new CheckboxEntry("Progress Bar", config.containerProgressBar, v -> config.containerProgressBar = v));
        entries.add(new CheckboxEntry("Steal Selected/Store Selected Buttons", config.containerStealStoreSelcted, v -> config.containerStealStoreSelcted = v));

        entries.add(new CategoryHeader("Game Menu (Single Player)"));
        entries.add(new CheckboxEntry("Save & Quit to World", config.gameMenuSingleSaveQuitWorld, v -> config.gameMenuSingleSaveQuitWorld = v));
        entries.add(new CheckboxEntry("Save & Quit Game", config.gameMenuSingleSaveQuitGame, v -> config.gameMenuSingleSaveQuitGame = v));

        entries.add(new CategoryHeader("Game Menu (Multiplayer)"));
        entries.add(new CheckboxEntry("Disconnect & Quit to World", config.gameMenuMultiDisconnectQuitWorld, v -> config.gameMenuMultiDisconnectQuitWorld = v));
        entries.add(new CheckboxEntry("Disconnect & Quit Game", config.gameMenuMultiDisconnectQuitGame, v -> config.gameMenuMultiDisconnectQuitGame = v));

        entries.add(new CategoryHeader("Resource Packs"));
        entries.add(new CheckboxEntry("Add All Button", config.resourcePackAddAll, v -> config.resourcePackAddAll = v));
        entries.add(new CheckboxEntry("Remove All Button", config.resourcePackRemoveAll, v -> config.resourcePackRemoveAll = v));

        entries.add(new CategoryHeader("Every Screen"));
        entries.add(new CheckboxEntry("?", config.everyScreenModGuideButton, v -> config.everyScreenModGuideButton = v));


        // הוספת כל הכפתורים לרשימת הילדים של המסך
        for (ConfigEntry entry : entries) {
            if (entry instanceof CheckboxEntry) {
                CheckboxEntry checkbox = (CheckboxEntry) entry;
                this.method_37063(checkbox.button); // הוספת הכפתור כילד!
            }
            if (entry instanceof CategoryHeader) {
                CategoryHeader header = (CategoryHeader) entry;
                this.method_37063(header.label); // הוספת הכותרת למסך
            }
        }
    }



    private int calculateTotalContentHeight() {
        int total = 0;
        for (ConfigEntry entry : entries) {
            total += entry.getHeight() + 4;
        }
        return total + 20;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        // רקע ללא טשטוש
        this.renderBackgroundTexture(context);

        // ציור כותרת
        context.method_27534(field_22793, field_22785, field_22789 / 2, 10, 0xFFFFFF);

        // גזירה לאזור הגלילה
        class_768 scrollArea = new class_768(
                scrollable.x,
                scrollable.y,
                scrollable.width,
                scrollable.height
        );
        context.method_44379(scrollArea.method_3321(), scrollArea.method_3322(),
                scrollArea.method_3321() + scrollArea.method_3319(),
                scrollArea.method_3322() + scrollArea.method_3320());

        // רינדור תוכן הגלילה
        scrollable.render(context, mouseX, mouseY, delta);

        // כיבוי גזירה
        context.method_44380();

        // רינדור כפתור השמור
        super.method_25394(context, mouseX, mouseY, delta);
        scrollable.renderScrollbar(context); // הוספנו את זה בנפרד
    }

    private void renderBackgroundTexture(class_332 context) {
        context.method_25296(0, 0, field_22789, field_22790, 0xC0101010, 0xD0101010);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (scrollable.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return scrollable.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) ||
                super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        return scrollable.mouseScrolled(mouseX, mouseY, horizontal, vertical);
    }

    private abstract class ConfigEntry {
        abstract void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta);

        abstract int getHeight();

        // Added this method to handle клиקים.
        boolean mouseClicked(double mouseX, double mouseY, int x, int y) {
            return false;
        }
    }

    private class CategoryHeader extends ConfigEntry {
        private final class_2561 text;
        private final net.minecraft.class_7842 label; // Add this

        CategoryHeader(String text) {
            this.text = class_2561.method_30163(text);
            this.label = new net.minecraft.class_7842(this.text, field_22793); // Initialize
        }

        @Override
        void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            //context.drawTextWithShadow(textRenderer, text, x + 5, y + 5, 0xFF00FF00); // שינוי הצבע ל-FF00FF00
            label.method_46421(x + 5);
            label.method_46419(y + 5);
            label.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        int getHeight() {
            return 20;
        }
    }

    private class CheckboxEntry extends ConfigEntry {
        private final class_2561 text;
        private boolean value;
        private final class_4185 button;
        private final Consumer<Boolean> setter;

        CheckboxEntry(String text, boolean initial, Consumer<Boolean> setter) {
            this.text = class_2561.method_30163(text);
            this.value = initial;
            this.setter = setter;
            this.button = class_4185.method_46430(getText(), b -> toggle()).method_46431();
        }

        private void toggle() {
            this.value = !this.value;
            setter.accept(this.value);
            button.method_25355(getText());
        }

        public void onClick() {
            toggle();
        }

        private class_2561 getText() {
            return class_2561.method_43470(text.getString() + ": " + (value ? "ON" : "OFF"));
        }

        @Override
        void render(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            // עדכון מיקום דינמי לפי גלילה
            button.method_46421(x + 10);
            button.method_46419(y);
            button.method_25358(220); // הגדלת רוחב הכפתור ב-20
            button.method_25394(context, mouseX, mouseY, delta);
        }

        @Override
        int getHeight() {
            return 20;
        }

        @Override
        boolean mouseClicked(double mouseX, double mouseY, int x, int y) {
            if (mouseX >= x + 10 && mouseX <= x + 10 + 220 && mouseY >= y && mouseY <= y + 20) { // התאמת אזור הלחיצה
                onClick();
                return true;
            }
            return false;
        }
    }

    private class ScrollableWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final int contentHeight;
        private double scrollAmount;

        ScrollableWidget(int x, int y, int width, int height, int contentHeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.contentHeight = contentHeight;
        }

        void render(class_332 context, int mouseX, int mouseY, float delta) {
            int currentY = y - (int) scrollAmount;
            for (ConfigEntry entry : entries) {
                entry.render(context, x, currentY, mouseX, mouseY, delta);
                currentY += entry.getHeight() + 4;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!isMouseOver(mouseX, mouseY)) return false;

            double adjustedY = mouseY - y + scrollAmount;
            int currentY = 0;
            for (ConfigEntry entry : entries) {
                int entryHeight = entry.getHeight();
                if (adjustedY >= currentY && adjustedY < currentY + entryHeight) {
                    if (entry.mouseClicked(mouseX, mouseY - y + scrollAmount, x, currentY)) {
                        return true;
                    }
                }
                currentY += entryHeight + 4;
            }
            return false;
        }


        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= x && mouseX <= x + width &&
                    mouseY >= y && mouseY <= y + height;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (button == 0 && isMouseOverScrollbar(mouseX, mouseY)) {
                float scrollPercent = (float) (mouseY - y) / height;
                scrollAmount = scrollPercent * (contentHeight - height);
                scrollAmount = Math.max(0, Math.min(scrollAmount, contentHeight - height));
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
            if (isMouseOver(mouseX, mouseY)) {
                scrollAmount = Math.max(0, Math.min(scrollAmount - vertical * 10, contentHeight - height));
                return true;
            }
            return false;
        }

        private boolean isMouseOverScrollbar(double mouseX, double mouseY) {
            int scrollbarX = x + width - 8;
            return mouseX >= scrollbarX &&
                    mouseX <= scrollbarX + 8 &&
                    mouseY >= y &&
                    mouseY <= y + height;
        }

        void renderScrollbar(class_332 context) {
            if (contentHeight <= height) return;

            int scrollbarWidth = 6;
            int scrollbarX = x + width - scrollbarWidth - 2;
            float scrollProgress = (float) scrollAmount / (contentHeight - height);
            int scrollbarHeight = (int) (height * (height / (float) contentHeight));

            scrollbarHeight = Math.max(scrollbarHeight, 32);
            int scrollbarY = y + (int) (scrollProgress * (height - scrollbarHeight));

            // רקע
            context.method_25294(scrollbarX, y, scrollbarX + scrollbarWidth, y + height, 0x80000000);
            // ידית
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, 0xFF00FF00);
        }
    }
}

