package net.xtreamc.booster.screen;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class HowToUseScreen extends class_437 {
    private final class_437 parent;
    private ScrollableWidget scrollable;

    public HowToUseScreen(class_437 parent) {
        super(class_2561.method_43471("booster.howto.title"));
        this.parent = parent;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(class_4185.method_46430(
                        class_2561.method_43471("gui.back"),
                        button -> class_310.method_1551().method_1507(parent))
                .method_46434(4, 4, 50, 20)
                .method_46431()
        );
        this.scrollable = new ScrollableWidget(
                field_22789 / 2 - 180,
                30,
                360,
                field_22790 - 60,
                calculateContentHeight()
        );
    }

    private int calculateContentHeight() {
        // חישוב דינמי לפי מבנה התוכן בפועל
        int categories = 8; // מספר הקטגוריות
        int bullets = 22;   // מספר הבולטים הכולל

        // 20px לקטגוריה + 15px לבולט רגיל + 5px נוסף לבולט אחרון בכל קטגוריה
        return (categories * 25) + (bullets * 15) + (categories * 5);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(
                field_22793,
                field_22785,
                field_22789 / 2,
                10,
                0xFFFFFF
        );
        scrollable.renderContent(context, mouseX, mouseY, delta);
        scrollable.renderScrollbar(context);
    }



    private void renderBackgroundTexture(class_332 context) {
        context.method_25296(0, 0, field_22789, field_22790, 0xC0101010, 0xD0101010);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        return this.scrollable.mouseScrolled(mouseX, mouseY, horizontal, vertical);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.scrollable.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private class ScrollableWidget {
        private final int x, y, width, height, contentHeight;
        private double scrollAmount;

        public ScrollableWidget(int x, int y, int width, int height, int contentHeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.contentHeight = contentHeight;
        }

        public void renderContent(class_332 context, int currentY, float delta, float v) {
            context.method_44379(x, y, x + width, y + height);
            currentY = y - (int) scrollAmount;

            // קטגוריית צ'אט
            drawCategory(context, currentY, "booster.howto.chat"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.chat.clear"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.chat.coords"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.chat.quickmsg"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.chat.hover"); currentY += 20;

            // קטגוריית מוות
            drawCategory(context, currentY, "booster.howto.death"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.death.coords"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.death.inventory"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.death.teleport"); currentY += 20;

            // קטגוריית אינבנטורי
            drawCategory(context, currentY, "booster.howto.inventory"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.inventory.search"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.inventory.lock"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.inventory.drop"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.inventory.progress"); currentY += 20;

            // קטגוריית מכולות
            drawCategory(context, currentY, "booster.howto.containers"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.containers.steal"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.containers.store"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.containers.progress"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.containers.multiselect"); currentY += 20;

            // קטגוריית יצירה
            drawCategory(context, currentY, "booster.howto.crafting"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.crafting.all"); currentY += 20;

            // קטגוריית משאבים
            drawCategory(context, currentY, "booster.howto.resourcepacks"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.resourcepacks.addall"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.resourcepacks.removeall"); currentY += 20;

            // קטגוריית תפריט משחק
            drawCategory(context, currentY, "booster.howto.gamemenu"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.gamemenu.singleplayer"); currentY += 15;
            drawBullet(context, currentY, "booster.howto.gamemenu.multiplayer"); currentY += 20;

            // קטגוריית רשת
            drawCategory(context, currentY, "booster.howto.multiplayer"); currentY += 20;
            drawBullet(context, currentY, "booster.howto.multiplayer.lastserver"); currentY += 15;

            context.method_44380();
        }

        public void renderScrollbar(class_332 context) {
            if (contentHeight <= height) {
                return;
            }
            int scrollbarWidth = 6;
            int scrollbarX = x + width - scrollbarWidth - 2;
            float scrollProgress = (float) scrollAmount / (contentHeight - height);
            int scrollbarHeight = (int) (height * (height / (float) contentHeight));
            scrollbarHeight = Math.max(scrollbarHeight, 32);
            int scrollbarY = y + (int) (scrollProgress * (height - scrollbarHeight));

            context.method_25294(scrollbarX, y, scrollbarX + scrollbarWidth, y + height, 0x80000000);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + scrollbarWidth, scrollbarY + scrollbarHeight, 0xFF00FF00);
        }

        private void drawCategory(class_332 context, int yPos, String key) {
            class_2561 text = class_2561.method_43471(key).method_27695(class_124.field_1067, class_124.field_1073);
            int textWidth = field_22793.method_27525(text);
            context.method_27535(field_22793, text, x + (width - textWidth) / 2, yPos, 0x00FF00);
        }

        private void drawBullet(class_332 context, int yPos, String key) {
            class_2561 text = class_2561.method_43470(" » ").method_10852(class_2561.method_43471(key));
            int textWidth = field_22793.method_27525(text);
            context.method_27535(field_22793, text, x + (width - textWidth)/2, yPos, 0xFFFFFF);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
            if (mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height) {
                scrollAmount = Math.max(0, Math.min(scrollAmount - vertical * 10, contentHeight - height));
                return true;
            }
            return false;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            int scrollbarX = x + width - 8;
            if (button == 0 && mouseX >= scrollbarX && mouseX <= scrollbarX + 8 && mouseY >= y && mouseY <= y + height) {
                float scrollPercent = (float) (mouseY - y) / height;
                scrollAmount = scrollPercent * (contentHeight - height);
                scrollAmount = Math.max(0, Math.min(scrollAmount, contentHeight - height));
                return true;
            }
            return false;
        }
    }
}