/*
 * Decompiled with CFR 0.152.
 */
package dev.popcorn.healtimer.utils;

import dev.popcorn.healtimer.config.ModConfig;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class CooldownUtils {
    private static final Map<UUID, Long> cooldownStartAt = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Float> lastHealth = new ConcurrentHashMap<UUID, Float>();

    private CooldownUtils() {
    }

    public static void startCooldown(UUID id) {
        cooldownStartAt.put(id, System.currentTimeMillis());
    }

    public static long getRemainingCooldownMillis(UUID id) {
        Long start = cooldownStartAt.get(id);
        if (start == null) {
            return 0L;
        }
        long elapsed = System.currentTimeMillis() - start;
        long duration = (long)Math.max(0, ModConfig.cooldown) * 1000L;
        long remaining = duration - elapsed;
        return Math.max(0L, remaining);
    }

    public static float getLastHealth(UUID id) {
        return lastHealth.getOrDefault(id, Float.valueOf(-1.0f)).floatValue();
    }

    public static void setLastHealth(UUID id, float health) {
        lastHealth.put(id, Float.valueOf(health));
    }

    public static void resetAll() {
        cooldownStartAt.clear();
        lastHealth.clear();
    }
}

