/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.mixin;

import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.states.EnabledState;
import dev.numbits.healtimer.utils.CooldownUtils;
import dev.numbits.healtimer.utils.LabelContext;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={class_897.class})
public abstract class HealCooldownNameplateMixin {
    @ModifyVariable(method={"renderLabelIfPresent(Lnet/minecraft/entity/Entity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_2561 healtimer$appendCooldown(class_2561 inText) {
        if (!EnabledState.get() || !ModConfig.enabled) {
            return inText;
        }
        if (!LabelContext.isPlayer()) {
            return inText;
        }
        UUID id = LabelContext.current();
        if (id == null) {
            return inText;
        }
        class_310 mc = class_310.method_1551();
        if (!ModConfig.showSelfNametag && mc.field_1724 != null && id.equals(mc.field_1724.method_5667())) {
            return inText;
        }
        if (!LabelContext.markNameAppendedOnce()) {
            return inText;
        }
        long ms = CooldownUtils.getRemainingCooldownMillis(id);
        int startRGB = ModConfig.startColor & 0xFFFFFF;
        int endRGB = ModConfig.endColor & 0xFFFFFF;
        class_5250 out = inText.method_27661().method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080));
        int checkColor = ModConfig.checkColor & 0xFFFFFF;
        if (ms > 0L) {
            long seconds = (ms + 999L) / 1000L;
            int total = Math.max(1, ModConfig.cooldown);
            int rgb = HealCooldownNameplateMixin.lerpRGB(startRGB, endRGB, seconds, total);
            out.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(seconds)).method_27694(s -> s.method_27703(class_5251.method_27717((int)rgb))));
        } else {
            out.method_10852((class_2561)class_2561.method_43470((String)"\u2714").method_27694(s -> s.method_27703(class_5251.method_27717((int)checkColor))));
        }
        return out;
    }

    private static int lerpRGB(int startRGB, int endRGB, long sec, int total) {
        float t = Math.min(1.0f, Math.max(0.0f, (float)sec / (float)total));
        int r1 = startRGB >> 16 & 0xFF;
        int g1 = startRGB >> 8 & 0xFF;
        int b1 = startRGB & 0xFF;
        int r2 = endRGB >> 16 & 0xFF;
        int g2 = endRGB >> 8 & 0xFF;
        int b2 = endRGB & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * (1.0f - t));
        int g = (int)((float)g1 + (float)(g2 - g1) * (1.0f - t));
        int b = (int)((float)b1 + (float)(b2 - b1) * (1.0f - t));
        return r << 16 | g << 8 | b;
    }
}

