/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.mixin;

import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.tracker.BelowNameTracker;
import dev.numbits.healtimer.tracker.PinkSurfaceTracker;
import dev.numbits.healtimer.utils.CooldownUtils;
import java.util.UUID;
import net.minecraft.class_2736;
import net.minecraft.class_2757;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class HealCooldownScoreboardMixin {
    @Unique
    private static final int SLOT_BELOW_NAME = 2;

    @Inject(method={"onScoreboardDisplay"}, at={@At(value="TAIL")})
    private void healtimer$onDisplay(class_2736 packet, CallbackInfo ci) {
        if (!ModConfig.enabled) {
            return;
        }
        if (packet.method_11806() == 2) {
            BelowNameTracker.setBelowNameObjective(packet.method_11804());
        }
    }

    @Inject(method={"onScoreboardPlayerUpdate"}, at={@At(value="TAIL")})
    private void healtimer$onScore(class_2757 packet, CallbackInfo ci) {
        float healed;
        if (!ModConfig.enabled) {
            return;
        }
        String below = BelowNameTracker.getBelowNameObjective();
        if (below.isEmpty() || !below.equals(packet.method_11864())) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1562() == null) {
            return;
        }
        String entry = packet.method_11862();
        class_640 ple = mc.method_1562().method_2874(entry);
        if (ple == null) {
            try {
                ple = mc.method_1562().method_2871(UUID.fromString(entry));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ple == null) {
            return;
        }
        UUID id = ple.method_2966().getId();
        if (id == null) {
            return;
        }
        if (PinkSurfaceTracker.wasRecentlyOnPink(id, 150)) {
            CooldownUtils.setLastHealth(id, packet.method_11865());
            return;
        }
        float cur = packet.method_11865();
        float last = CooldownUtils.getLastHealth(id);
        long remain = CooldownUtils.getRemainingCooldownMillis(id);
        if (last >= 0.0f && (healed = cur - last) >= (float)ModConfig.detectAmount && remain <= 0L) {
            CooldownUtils.startCooldown(id);
        }
        CooldownUtils.setLastHealth(id, cur);
    }
}

