/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.numbits.healtimer.HealTimer;
import dev.numbits.healtimer.config.ModOptions;
import dev.numbits.healtimer.utils.LoggerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\u00028\u0000\"\f\b\u0000\u0010\u000e*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR8\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u001bj\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r`\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010!\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u0006)"}, d2={"Ldev/numbits/healtimer/config/ModConfig;", "", "<init>", "()V", "", "load", "save", "Lcom/google/gson/JsonElement;", "json", "fromJson", "(Lcom/google/gson/JsonElement;)V", "toJson", "()Lcom/google/gson/JsonElement;", "Ldev/numbits/healtimer/config/ModOptions;", "T", "option", "addOption", "(Ldev/numbits/healtimer/config/ModOptions;)Ldev/numbits/healtimer/config/ModOptions;", "", "modid", "Ljava/lang/String;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "Ljava/io/File;", "file", "Ljava/io/File;", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "optionMap", "Ljava/util/LinkedHashMap;", "Ldev/numbits/healtimer/config/ModOptions$BooleanOption;", "enabled", "Ldev/numbits/healtimer/config/ModOptions$BooleanOption;", "getEnabled", "()Ldev/numbits/healtimer/config/ModOptions$BooleanOption;", "setEnabled", "(Ldev/numbits/healtimer/config/ModOptions$BooleanOption;)V", "showSelfNametag", "getShowSelfNametag", "setShowSelfNametag", "HealTimer"})
public final class ModConfig {
    @NotNull
    public static final ModConfig INSTANCE = new ModConfig();
    @NotNull
    private static String modid;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final File file;
    @NotNull
    private static final LinkedHashMap<String, ModOptions<?>> optionMap;
    @NotNull
    private static ModOptions.BooleanOption enabled;
    @NotNull
    private static ModOptions.BooleanOption showSelfNametag;

    private ModConfig() {
    }

    @NotNull
    public final ModOptions.BooleanOption getEnabled() {
        return enabled;
    }

    public final void setEnabled(@NotNull ModOptions.BooleanOption booleanOption) {
        Intrinsics.checkNotNullParameter((Object)booleanOption, (String)"<set-?>");
        enabled = booleanOption;
    }

    @NotNull
    public final ModOptions.BooleanOption getShowSelfNametag() {
        return showSelfNametag;
    }

    public final void setShowSelfNametag(@NotNull ModOptions.BooleanOption booleanOption) {
        Intrinsics.checkNotNullParameter((Object)booleanOption, (String)"<set-?>");
        showSelfNametag = booleanOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load() {
        if (file.exists()) {
            try {
                Closeable closeable = new FileReader(file);
                Throwable throwable = null;
                try {
                    FileReader reader = (FileReader)closeable;
                    boolean bl = false;
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    Intrinsics.checkNotNull((Object)json);
                    INSTANCE.fromJson(json);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                LoggerUtil.error$default(LoggerUtil.INSTANCE, "Failed to load config : " + e, null, 2, null);
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            File file = ModConfig.file.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            Closeable closeable = new FileWriter(ModConfig.file);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                gson.toJson(INSTANCE.toJson(), (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LoggerUtil.error$default(LoggerUtil.INSTANCE, "Failed to save config : " + e, null, 2, null);
        }
    }

    private final void fromJson(JsonElement json) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Json must be an object");
        }
        JsonObject obj = json.getAsJsonObject();
        for (Map.Entry entry : ((Map)optionMap).entrySet()) {
            String key = (String)entry.getKey();
            ModOptions option = (ModOptions)entry.getValue();
            if (obj.get(key) == null) continue;
            try {
                JsonElement element;
                option.fromJson(element);
            }
            catch (JsonParseException e) {
                LoggerUtil.error$default(LoggerUtil.INSTANCE, "Failed to parse JSON : " + e, null, 2, null);
            }
        }
    }

    private final JsonElement toJson() {
        JsonObject obj = new JsonObject();
        for (Map.Entry entry : ((Map)optionMap).entrySet()) {
            String key = (String)entry.getKey();
            ModOptions option = (ModOptions)entry.getValue();
            obj.add(key, option.toJson());
        }
        return (JsonElement)obj;
    }

    private final <T extends ModOptions<?>> T addOption(T option) {
        T old = optionMap.put(option.getKey(), option);
        if (old != null) {
            LoggerUtil.warn$default(LoggerUtil.INSTANCE, "Option with key=" + old.getKey() + " was overridden", null, 2, null);
        }
        return option;
    }

    static {
        String string = HealTimer.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        modid = string2;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        ModConfig.gson = gson;
        File file = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ModConfig.file = file;
        optionMap = new LinkedHashMap();
        enabled = (ModOptions.BooleanOption)INSTANCE.addOption((ModOptions)new ModOptions.BooleanOption("enabled", true));
        showSelfNametag = (ModOptions.BooleanOption)INSTANCE.addOption((ModOptions)new ModOptions.BooleanOption("show_self_nametag", true));
        INSTANCE.load();
    }
}

