/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.kop.healtimer.HealTimer;
import dev.kop.healtimer.config.ModOptions;
import dev.kop.healtimer.utils.LoggerUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public final class ModConfig {
    private static final String modid = HealTimer.class.getSimpleName().toLowerCase(Locale.ROOT);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final File file = FabricLoader.getInstance().getConfigDir().resolve(modid + ".json").toFile();
    private static final LinkedHashMap<String, ModOptions<?>> optionMap = new LinkedHashMap();
    public static final ModOptions.BooleanOption enabled = ModConfig.addOption(new ModOptions.BooleanOption("enabled", true));
    public static final ModOptions.BooleanOption showSelfNametag = ModConfig.addOption(new ModOptions.BooleanOption("show_self_nametag", true));
    public static final ModOptions.BooleanOption showSelfHealTimer = ModConfig.addOption(new ModOptions.BooleanOption("show_self_heal_timer", true));
    public static final ModOptions.IntOption healTimerHudX = ModConfig.addOption(new ModOptions.IntOption("heal_timer_hud_x", 10));
    public static final ModOptions.IntOption healTimerHudY = ModConfig.addOption(new ModOptions.IntOption("heal_timer_hud_y", 10));
    public static final ModOptions.BooleanOption useFloatSeconds = ModConfig.addOption(new ModOptions.BooleanOption("use_float_seconds", true));
    public static final ModOptions.BooleanOption showSquareBackets = ModConfig.addOption(new ModOptions.BooleanOption("show_square_brackets", true));

    private ModConfig() {
    }

    public static void load() {
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                ModConfig.fromJson(json);
            }
            catch (Exception e) {
                LoggerUtil.error("Failed to load config : " + String.valueOf(e));
            }
        }
        ModConfig.save();
    }

    public static void save() {
        try {
            boolean createSuccess;
            File parent = file.getParentFile();
            if (parent != null && !(createSuccess = parent.mkdirs())) {
                LoggerUtil.error("Failed to create config directory");
            }
            try (FileWriter writer = new FileWriter(file);){
                gson.toJson(ModConfig.toJson(), (Appendable)writer);
            }
        }
        catch (Exception e) {
            LoggerUtil.error("Failed to save config : " + String.valueOf(e));
        }
    }

    private static void fromJson(JsonElement json) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Json must be an object");
        }
        JsonObject obj = json.getAsJsonObject();
        for (Map.Entry<String, ModOptions<?>> entry : optionMap.entrySet()) {
            String key = entry.getKey();
            ModOptions<?> option = entry.getValue();
            JsonElement element = obj.get(key);
            if (element == null) continue;
            try {
                option.fromJson(element);
            }
            catch (JsonParseException e) {
                LoggerUtil.error("Failed to parse JSON : " + String.valueOf((Object)e));
            }
        }
    }

    private static JsonElement toJson() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, ModOptions<?>> entry : optionMap.entrySet()) {
            String key = entry.getKey();
            ModOptions<?> option = entry.getValue();
            obj.add(key, option.toJson());
        }
        return obj;
    }

    private static <T extends ModOptions<?>> T addOption(T option) {
        T old = optionMap.put(option.getKey(), option);
        if (old != null) {
            LoggerUtil.warn("Option with key=" + old.getKey() + " was overridden");
        }
        return option;
    }

    static {
        ModConfig.load();
    }
}

