/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.config;

import dev.kop.healtimer.config.HudConfigScreen;
import dev.kop.healtimer.config.ModConfig;
import dev.kop.healtimer.config.ModOptions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ModConfigScreen
extends class_437 {
    private final class_437 parent;
    private List<Value<?>> values;
    private static final class_2561 DONE_TEXT = class_2561.method_43471((String)"gui.done");
    private static final class_2561 CANCEL_TEXT = class_2561.method_43471((String)"gui.cancel");

    public ModConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)ModConfigScreen.getTranslationKey("title")));
        this.parent = parent;
    }

    protected void method_25426() {
        Value<Boolean> enabled = Value.of(ModConfig.enabled, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> showSelfNametag = Value.of(ModConfig.showSelfNametag, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> showSelfHealTimer = Value.of(ModConfig.showSelfHealTimer, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> useFloatSeconds = Value.of(ModConfig.useFloatSeconds, new Value.Flag[0]);
        Value<Boolean> showSquareBackets = Value.of(ModConfig.showSquareBackets, new Value.Flag[0]);
        this.values = Arrays.asList(enabled, showSelfNametag, showSelfHealTimer, useFloatSeconds, showSquareBackets);
        int centerX = this.field_22789 / 2 - 100;
        int startY = this.field_22790 / 2 - 60;
        int spacing = 25;
        this.method_37063((class_364)this.startBooleanValueButton(enabled).method_46434(centerX, startY, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(showSelfNametag).method_46434(centerX, startY + spacing, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(showSelfHealTimer).method_46434(centerX, startY + spacing * 2, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(useFloatSeconds).method_46434(centerX, startY + spacing * 3, 200, 20).method_46431());
        this.method_37063((class_364)this.startBooleanValueButton(showSquareBackets).method_46434(centerX, startY + spacing * 4, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)ModConfigScreen.getTranslationKey("move_self_heal_timer_hud")), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new HudConfigScreen(this));
            }
        }).method_46434(centerX, startY + spacing * 5, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)DONE_TEXT, button -> {
            this.saveValues();
            this.method_25419();
        }).method_46434(this.field_22789 / 2 - 75 - 79, this.field_22790 - 40, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)CANCEL_TEXT, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 75 + 79, this.field_22790 - 40, 150, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 30, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private void saveValues() {
        EnumSet<Value.Flag> flags = EnumSet.noneOf(Value.Flag.class);
        for (Value<?> value : this.values) {
            if (!value.isChanged()) continue;
            value.saveToOption();
            flags.addAll(value.flags);
        }
        ModConfig.save();
        for (Value.Flag flag : flags) {
            flag.onSave();
        }
    }

    private class_4185.class_7840 startBooleanValueButton(Value<Boolean> value) {
        String translationKey = ModConfigScreen.getTranslationKey(value.option.getKey());
        class_5250 label = class_2561.method_43471((String)translationKey);
        class_5250 tooltipText = class_2561.method_43471((String)ModConfigScreen.getTooltipKey(translationKey));
        class_2561 valueText = ModConfigScreen.getColoredOnOffText(value.get());
        return class_4185.method_46430((class_2561)ModConfigScreen.composeGenericOptionText((class_2561)label, valueText), arg_0 -> ModConfigScreen.lambda$startBooleanValueButton$3(value, (class_2561)label, arg_0)).method_46436(class_7919.method_47407((class_2561)tooltipText));
    }

    private static String getTranslationKey(String optionKey) {
        return "options.healtimer." + optionKey;
    }

    private static String getTooltipKey(String translationKey) {
        return translationKey + ".tooltip";
    }

    private static class_2561 composeGenericOptionText(class_2561 label, class_2561 value) {
        return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{label, value});
    }

    private static class_2561 getColoredOnOffText(boolean value) {
        if (value) {
            return class_2561.method_43470((String)"ON").method_27694(style -> style.method_36139(588414).method_10982(Boolean.valueOf(true)));
        }
        return class_2561.method_43470((String)"OFF").method_27694(style -> style.method_36139(0xFF3F3F).method_10982(Boolean.valueOf(true)));
    }

    private static /* synthetic */ void lambda$startBooleanValueButton$3(Value value, class_2561 label, class_4185 button) {
        boolean newValue = (Boolean)value.get() == false;
        value.set(newValue);
        class_2561 newValueText = ModConfigScreen.getColoredOnOffText(newValue);
        button.method_25355(ModConfigScreen.composeGenericOptionText(label, newValueText));
    }

    private static class Value<T> {
        final ModOptions<T> option;
        final EnumSet<Flag> flags;
        private final T originalValue;
        private T value;

        Value(ModOptions<T> option, EnumSet<Flag> flags) {
            this.option = option;
            this.flags = flags;
            this.originalValue = option.get();
            this.value = this.originalValue;
        }

        T get() {
            return this.value;
        }

        void set(T newValue) {
            this.value = newValue;
        }

        boolean isChanged() {
            return !Objects.equals(this.value, this.originalValue);
        }

        void saveToOption() {
            this.option.set(this.value);
        }

        static <T> Value<T> of(ModOptions<T> option, Flag ... flags) {
            EnumSet<Flag> flagSet;
            if (flags != null && flags.length > 0) {
                flagSet = EnumSet.noneOf(Flag.class);
                flagSet.addAll(Arrays.asList(flags));
            } else {
                flagSet = EnumSet.noneOf(Flag.class);
            }
            return new Value<T>(option, flagSet);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static enum Flag {
            RELOAD_WORLD_RENDERER{

                @Override
                public void onSave() {
                    class_310 client = class_310.method_1551();
                    if (client != null && client.field_1769 != null) {
                        client.field_1769.method_3279();
                    }
                }
            };


            public abstract void onSave();
        }
    }
}

