/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.handlers;

import dev.kop.healtimer.hud.HudRenderer;
import dev.kop.healtimer.storage.CooldownStore;
import dev.kop.healtimer.trackers.PinkSurfaceTracker;
import java.util.Locale;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_642;

public final class EventHandler {
    private EventHandler() {
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> EventHandler.handleServerJoin(client));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> EventHandler.handleServerDisconnect(client));
        ClientTickEvents.END_CLIENT_TICK.register(client -> PinkSurfaceTracker.tick(client));
        HudRenderCallback.EVENT.register((context, tickDelta) -> HudRenderer.render(context, tickDelta));
    }

    private static void handleServerJoin(class_310 client) {
        String host = EventHandler.getCurrentServerHost(client);
        if (host == null) {
            return;
        }
        if (host.equals("craftm.kr")) {
            EventHandler.onJoinCraftm(client);
        } else if (host.equals("rtsv24.kr")) {
            EventHandler.onJoinRtsv24(client);
        } else {
            EventHandler.onJoinRtsv24(client);
        }
    }

    private static void handleServerDisconnect(class_310 client) {
        CooldownStore.clearAll();
    }

    private static String getCurrentServerHost(class_310 client) {
        if (client == null) {
            return null;
        }
        class_642 serverInfo = client.method_1558();
        if (serverInfo == null) {
            return null;
        }
        String address = serverInfo.field_3761;
        if (address == null) {
            return null;
        }
        int idx = address.indexOf(58);
        String host = idx >= 0 ? address.substring(0, idx) : address;
        return host.toLowerCase(Locale.ROOT);
    }

    private static void onJoinCraftm(class_310 client) {
    }

    private static void onJoinRtsv24(class_310 client) {
    }
}

