/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.hud;

import dev.kop.healtimer.config.ModConfig;
import dev.kop.healtimer.storage.CooldownStore;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public final class HudRenderer {
    private static final int BOX_WIDTH = 140;
    private static final int BOX_HEIGHT = 28;

    private HudRenderer() {
    }

    public static void render(class_332 context, float tickDelta) {
        class_5250 inner;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return;
        }
        if (!((Boolean)ModConfig.enabled.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)ModConfig.showSelfHealTimer.get()).booleanValue()) {
            return;
        }
        long ms = CooldownStore.getRemainingCooldownMillis((class_1657)mc.field_1724);
        class_327 textRenderer = mc.field_1772;
        boolean useFloat = (Boolean)ModConfig.useFloatSeconds.get();
        int gray = 0xAAAAAA;
        class_5250 leftBracket = class_2561.method_43470((String)"[").method_27694(style -> style.method_36139(gray));
        class_5250 rightBracket = class_2561.method_43470((String)"]").method_27694(style -> style.method_36139(gray));
        if (ms <= 0L) {
            String heart = class_2561.method_43471((String)"hud.healtimer.heart").getString();
            inner = class_2561.method_43470((String)heart).method_27694(style -> style.method_27703(class_5251.method_27717((int)3405724)));
        } else {
            long remainingMs = Math.max(0L, ms);
            float secondsFloat = (float)remainingMs / 1000.0f;
            long secondsInt = (remainingMs + 999L) / 1000L;
            String secondsText = useFloat ? String.format(Locale.US, "%.1f", Float.valueOf(secondsFloat)) : Long.toString(secondsInt);
            float secondsForLerp = useFloat ? secondsFloat : (float)secondsInt;
            float total = 60.0f;
            int rgb = HudRenderer.lerpRGB(16202044, 3405724, secondsForLerp, total);
            inner = class_2561.method_43470((String)secondsText).method_27694(style -> style.method_27703(class_5251.method_27717((int)rgb)));
        }
        class_5250 line = (Boolean)ModConfig.showSquareBackets.get() != false ? leftBracket.method_27661().method_27693(" ").method_10852((class_2561)inner).method_27693(" ").method_10852((class_2561)rightBracket) : inner.method_27661();
        int anchorX = (Integer)ModConfig.healTimerHudX.get();
        int anchorY = (Integer)ModConfig.healTimerHudY.get();
        int textWidth = textRenderer.method_27525((class_5348)line);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int drawX = anchorX + (140 - textWidth) / 2;
        int drawY = anchorY + (28 - textHeight) / 2;
        context.method_27535(textRenderer, (class_2561)line, drawX, drawY, 0xFFFFFF);
    }

    private static int lerpRGB(int start, int end, float value, float max) {
        float t;
        if (max <= 0.0f) {
            t = 1.0f;
        } else {
            t = value / max;
            if (t < 0.0f) {
                t = 0.0f;
            }
            if (t > 1.0f) {
                t = 1.0f;
            }
        }
        int sr = start >> 16 & 0xFF;
        int sg = start >> 8 & 0xFF;
        int sb = start & 0xFF;
        int er = end >> 16 & 0xFF;
        int eg = end >> 8 & 0xFF;
        int eb = end & 0xFF;
        int r = (int)((float)sr + (float)(er - sr) * t);
        int g = (int)((float)sg + (float)(eg - sg) * t);
        int b = (int)((float)sb + (float)(eb - sb) * t);
        return r << 16 | g << 8 | b;
    }
}

