/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.storage;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;

public final class CooldownStore {
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Float> lastHealths = new ConcurrentHashMap<UUID, Float>();
    private static final Set<UUID> ignoreCooldown = ConcurrentHashMap.newKeySet();

    private CooldownStore() {
    }

    private static long getCooldownNanos() {
        return Math.max(1L, 60L) * 1000000000L;
    }

    public static void clearAll() {
        cooldowns.clear();
        lastHealths.clear();
        ignoreCooldown.clear();
    }

    public static void ignoreCooldown(UUID id) {
        ignoreCooldown.add(id);
        cooldowns.remove(id);
    }

    public static void unignoreCooldown(UUID id) {
        ignoreCooldown.remove(id);
    }

    public static boolean isCooldownIgnored(UUID id) {
        return ignoreCooldown.contains(id);
    }

    public static boolean isCooldownIgnored(class_1657 player) {
        return CooldownStore.isCooldownIgnored(player.method_5667());
    }

    public static void startCooldown(UUID id) {
        CooldownStore.startCooldown(id, false);
    }

    public static void startCooldown(UUID id, boolean forceRestart) {
        if (ignoreCooldown.contains(id)) {
            return;
        }
        long now = System.nanoTime();
        if (forceRestart) {
            cooldowns.put(id, now);
        } else {
            cooldowns.putIfAbsent(id, now);
        }
    }

    public static void startCooldown(class_1657 player) {
        CooldownStore.startCooldown(player, false);
    }

    public static void startCooldown(class_1657 player, boolean forceRestart) {
        CooldownStore.startCooldown(player.method_5667(), forceRestart);
    }

    public static long getRemainingCooldownMillis(UUID id) {
        if (ignoreCooldown.contains(id)) {
            cooldowns.remove(id);
            return 0L;
        }
        Long start = cooldowns.get(id);
        if (start == null) {
            return 0L;
        }
        long elapsed = System.nanoTime() - start;
        long remaining = CooldownStore.getCooldownNanos() - elapsed;
        if (remaining <= 0L) {
            cooldowns.remove(id);
            return 0L;
        }
        return remaining / 1000000L;
    }

    public static long getRemainingCooldownMillis(class_1657 player) {
        return CooldownStore.getRemainingCooldownMillis(player.method_5667());
    }

    public static float getLastHealth(UUID id) {
        Float value = lastHealths.get(id);
        return value != null ? value.floatValue() : -1.0f;
    }

    public static float getLastHealth(class_1657 player) {
        return CooldownStore.getLastHealth(player.method_5667());
    }

    public static void setLastHealth(UUID id, float health) {
        lastHealths.put(id, Float.valueOf(health));
    }

    public static void setLastHealth(class_1657 player, float health) {
        CooldownStore.setLastHealth(player.method_5667(), health);
    }
}

