/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.trackers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public final class PinkSurfaceTracker {
    private static final Map<UUID, Long> lastOnPinkMs = new ConcurrentHashMap<UUID, Long>();

    private PinkSurfaceTracker() {
    }

    public static void tick(class_310 mc) {
        if (mc == null) {
            return;
        }
        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        for (class_1657 player : world.method_18456()) {
            if (!PinkSurfaceTracker.isOnPink((class_1937)world, player)) continue;
            lastOnPinkMs.put(player.method_5667(), System.currentTimeMillis());
        }
    }

    public static boolean wasRecentlyOnPink(UUID id, int windowMs) {
        Long t = lastOnPinkMs.get(id);
        if (t == null) {
            return false;
        }
        int window = Math.max(0, windowMs);
        return System.currentTimeMillis() - t <= (long)window;
    }

    private static boolean isOnPink(class_1937 world, class_1657 player) {
        if (world == null || player == null) {
            return false;
        }
        class_2338 feet = player.method_24515();
        class_2338 under = feet.method_10074();
        if (PinkSurfaceTracker.isPink(world.method_8320(feet).method_26204())) {
            return true;
        }
        if (PinkSurfaceTracker.isPink(world.method_8320(under).method_26204())) {
            return true;
        }
        class_238 box = player.method_5829().method_989(0.0, -0.05, 0.0);
        int minX = class_3532.method_15357((double)box.field_1323);
        int maxX = class_3532.method_15357((double)box.field_1320);
        int minZ = class_3532.method_15357((double)box.field_1321);
        int maxZ = class_3532.method_15357((double)box.field_1324);
        int y = class_3532.method_15357((double)box.field_1322);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                class_2338 pos = new class_2338(x, y, z);
                if (PinkSurfaceTracker.isPink(world.method_8320(pos).method_26204())) {
                    return true;
                }
                class_2338 below = pos.method_10074();
                if (!PinkSurfaceTracker.isPink(world.method_8320(below).method_26204())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPink(class_2248 block) {
        return block == class_2246.field_10434;
    }
}

