/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.utils;

import java.util.UUID;
import net.minecraft.class_1297;

public final class LabelContext {
    private static final ThreadLocal<UUID> current = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<Boolean> isPlayer = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Boolean> nameAppended = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<Integer> labelLineIndex = ThreadLocal.withInitial(() -> 0);

    private LabelContext() {
    }

    public static void setCurrentForRender(class_1297 entity, boolean isPlayerFlag) {
        current.set(entity != null ? entity.method_5667() : null);
        isPlayer.set(isPlayerFlag);
        nameAppended.set(false);
        labelLineIndex.set(0);
    }

    public static UUID current() {
        return current.get();
    }

    public static boolean isPlayer() {
        return isPlayer.get();
    }

    public static int nextLabelLine() {
        int i = labelLineIndex.get();
        labelLineIndex.set(i + 1);
        return i;
    }

    public static boolean markNameAppendedOnce() {
        if (nameAppended.get().booleanValue()) {
            return false;
        }
        nameAppended.set(true);
        return true;
    }

    public static void clear() {
        current.remove();
        isPlayer.remove();
        nameAppended.remove();
        labelLineIndex.remove();
    }
}

