/*
 * Decompiled with CFR 0.152.
 */
package dev.kop.healtimer.utils;

import dev.kop.healtimer.HealTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerUtil {
    public static final String MOD_PREFIX = "[" + HealTimer.class.getSimpleName() + "]";
    public static final Logger logger = LoggerFactory.getLogger(HealTimer.class);

    private LoggerUtil() {
    }

    public static void info(String msg) {
        LoggerUtil.info(msg, null);
    }

    public static void info(String msg, String source) {
        logger.info(LoggerUtil.format(msg, source));
    }

    public static void warn(String msg) {
        LoggerUtil.warn(msg, null);
    }

    public static void warn(String msg, String source) {
        logger.warn(LoggerUtil.format(msg, source));
    }

    public static void error(String msg) {
        LoggerUtil.error(msg, null);
    }

    public static void error(String msg, String source) {
        logger.error(LoggerUtil.format(msg, source));
    }

    private static String format(String msg, String source) {
        Object src = source != null ? "[" + source + "]" : "";
        return MOD_PREFIX + " " + (String)src + " " + msg;
    }
}

