/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healtimer.hud;

import dev.numbits.healtimer.config.DefaultConfig;
import dev.numbits.healtimer.config.ModConfig;
import dev.numbits.healtimer.store.CooldownStore;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Ldev/numbits/healtimer/hud/HealTimerHudRenderer;", "", "<init>", "()V", "Lnet/minecraft/class_332;", "context", "", "tickDelta", "", "render", "(Lnet/minecraft/class_332;F)V", "", "start", "end", "value", "max", "lerpRGB", "(IIFF)I", "BOX_WIDTH", "I", "BOX_HEIGHT", "HealTimer"})
public final class HealTimerHudRenderer {
    @NotNull
    public static final HealTimerHudRenderer INSTANCE = new HealTimerHudRenderer();
    private static final int BOX_WIDTH = 140;
    private static final int BOX_HEIGHT = 28;

    private HealTimerHudRenderer() {
    }

    public final void render(@NotNull class_332 context, float tickDelta) {
        class_2561 class_25612;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        class_310 mc = class_310.method_1551();
        class_746 class_7462 = mc.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        if (!((Boolean)ModConfig.INSTANCE.getEnabled().get()).booleanValue()) {
            return;
        }
        if (!((Boolean)ModConfig.INSTANCE.getShowSelfHealTimer().get()).booleanValue()) {
            return;
        }
        long ms = CooldownStore.INSTANCE.getRemainingCooldownMillis((class_1657)player);
        class_327 textRenderer = mc.field_1772;
        boolean useFloat = (Boolean)ModConfig.INSTANCE.getUseFloatSeconds().get();
        int gray = 0xAAAAAA;
        class_5250 leftBracket = class_2561.method_43470((String)"[").method_27694(arg_0 -> HealTimerHudRenderer.render$lambda$0(gray, arg_0));
        class_5250 rightBracket = class_2561.method_43470((String)"]").method_27694(arg_0 -> HealTimerHudRenderer.render$lambda$1(gray, arg_0));
        if (ms <= 0L) {
            String heart = class_2561.method_43471((String)"hud.healtimer.heart").getString();
            class_5250 inner = class_2561.method_43470((String)heart).method_27694(HealTimerHudRenderer::render$lambda$2);
            var13_16 = leftBracket.method_27661().method_27693(" ").method_10852((class_2561)inner).method_27693(" ").method_10852((class_2561)rightBracket);
            Intrinsics.checkNotNull((Object)var13_16);
            class_25612 = (class_2561)var13_16;
        } else {
            String string;
            long remainingMs = RangesKt.coerceAtLeast((long)ms, (long)0L);
            float secondsFloat = (float)remainingMs / 1000.0f;
            long secondsInt = (remainingMs + 999L) / 1000L;
            if (useFloat) {
                Locale locale = Locale.US;
                String string2 = "%.1f";
                Object[] objectArray = new Object[]{Float.valueOf(secondsFloat)};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                string = String.valueOf(secondsInt);
            }
            String secondsText = string;
            float secondsForLerp = useFloat ? secondsFloat : (float)secondsInt;
            float total = 60.0f;
            int rgb = this.lerpRGB(DefaultConfig.INSTANCE.getStartRGB(), DefaultConfig.INSTANCE.getEndRGB(), secondsForLerp, total);
            class_5250 inner = class_2561.method_43470((String)secondsText).method_27694(arg_0 -> HealTimerHudRenderer.render$lambda$3(rgb, arg_0));
            var13_16 = leftBracket.method_27661().method_27693(" ").method_10852((class_2561)inner).method_27693(" ").method_10852((class_2561)rightBracket);
            Intrinsics.checkNotNull((Object)var13_16);
            class_25612 = (class_2561)var13_16;
        }
        class_2561 line = class_25612;
        int anchorX = ((Number)ModConfig.INSTANCE.getHealTimerHudX().get()).intValue();
        int anchorY = ((Number)ModConfig.INSTANCE.getHealTimerHudY().get()).intValue();
        int textWidth = textRenderer.method_27525((class_5348)line);
        int textHeight = textRenderer.field_2000;
        int drawX = anchorX + (140 - textWidth) / 2;
        int drawY = anchorY + (28 - textHeight) / 2;
        context.method_27535(textRenderer, line, drawX, drawY, 0xFFFFFF);
    }

    private final int lerpRGB(int start, int end, float value, float max) {
        float t = max <= 0.0f ? 1.0f : RangesKt.coerceIn((float)(value / max), (float)0.0f, (float)1.0f);
        int sr = start >> 16 & 0xFF;
        int sg = start >> 8 & 0xFF;
        int sb = start & 0xFF;
        int er = end >> 16 & 0xFF;
        int eg = end >> 8 & 0xFF;
        int eb = end & 0xFF;
        int r = (int)((float)sr + (float)(er - sr) * t);
        int g = (int)((float)sg + (float)(eg - sg) * t);
        int b = (int)((float)sb + (float)(eb - sb) * t);
        return r << 16 | g << 8 | b;
    }

    private static final class_2583 render$lambda$0(int $gray, class_2583 it) {
        return it.method_36139($gray);
    }

    private static final class_2583 render$lambda$1(int $gray, class_2583 it) {
        return it.method_36139($gray);
    }

    private static final class_2583 render$lambda$2(class_2583 s) {
        return s.method_27703(class_5251.method_27717((int)DefaultConfig.INSTANCE.getCheckRGB()));
    }

    private static final class_2583 render$lambda$3(int $rgb, class_2583 s) {
        return s.method_27703(class_5251.method_27717((int)$rgb));
    }
}

